/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Influence
implements JsonpSerializable {
    private final String influencerFieldName;
    private final List<String> influencerFieldValues;
    public static final JsonpDeserializer<Influence> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Influence::setupInfluenceDeserializer);

    private Influence(Builder builder) {
        this.influencerFieldName = ApiTypeHelper.requireNonNull(builder.influencerFieldName, this, "influencerFieldName");
        this.influencerFieldValues = ApiTypeHelper.unmodifiableRequired(builder.influencerFieldValues, (Object)this, "influencerFieldValues");
    }

    public static Influence of(Function<Builder, ObjectBuilder<Influence>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String influencerFieldName() {
        return this.influencerFieldName;
    }

    public final List<String> influencerFieldValues() {
        return this.influencerFieldValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("influencer_field_name");
        generator.write(this.influencerFieldName);
        if (ApiTypeHelper.isDefined(this.influencerFieldValues)) {
            generator.writeKey("influencer_field_values");
            generator.writeStartArray();
            for (String item0 : this.influencerFieldValues) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupInfluenceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::influencerFieldName, JsonpDeserializer.stringDeserializer(), "influencer_field_name");
        op.add(Builder::influencerFieldValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "influencer_field_values");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Influence> {
        private String influencerFieldName;
        private List<String> influencerFieldValues;

        public Builder() {
        }

        private Builder(Influence instance) {
            this.influencerFieldName = instance.influencerFieldName;
            this.influencerFieldValues = instance.influencerFieldValues;
        }

        public final Builder influencerFieldName(String value) {
            this.influencerFieldName = value;
            return this;
        }

        public final Builder influencerFieldValues(List<String> list) {
            this.influencerFieldValues = Builder._listAddAll(this.influencerFieldValues, list);
            return this;
        }

        public final Builder influencerFieldValues(String value, String ... values) {
            this.influencerFieldValues = Builder._listAdd(this.influencerFieldValues, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Influence build() {
            this._checkSingleUse();
            return new Influence(this);
        }
    }
}

