/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DatafeedRunningState;
import co.elastic.clients.elasticsearch.ml.DatafeedState;
import co.elastic.clients.elasticsearch.ml.DatafeedTimingStats;
import co.elastic.clients.elasticsearch.ml.DiscoveryNodeCompact;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DatafeedStats
implements JsonpSerializable {
    @Nullable
    private final String assignmentExplanation;
    private final String datafeedId;
    @Nullable
    private final DiscoveryNodeCompact node;
    private final DatafeedState state;
    @Nullable
    private final DatafeedTimingStats timingStats;
    @Nullable
    private final DatafeedRunningState runningState;
    public static final JsonpDeserializer<DatafeedStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedStats::setupDatafeedStatsDeserializer);

    private DatafeedStats(Builder builder) {
        this.assignmentExplanation = builder.assignmentExplanation;
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.node = builder.node;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.timingStats = builder.timingStats;
        this.runningState = builder.runningState;
    }

    public static DatafeedStats of(Function<Builder, ObjectBuilder<DatafeedStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String assignmentExplanation() {
        return this.assignmentExplanation;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final DiscoveryNodeCompact node() {
        return this.node;
    }

    public final DatafeedState state() {
        return this.state;
    }

    @Nullable
    public final DatafeedTimingStats timingStats() {
        return this.timingStats;
    }

    @Nullable
    public final DatafeedRunningState runningState() {
        return this.runningState;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.assignmentExplanation != null) {
            generator.writeKey("assignment_explanation");
            generator.write(this.assignmentExplanation);
        }
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        if (this.node != null) {
            generator.writeKey("node");
            this.node.serialize(generator, mapper);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        if (this.timingStats != null) {
            generator.writeKey("timing_stats");
            this.timingStats.serialize(generator, mapper);
        }
        if (this.runningState != null) {
            generator.writeKey("running_state");
            this.runningState.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDatafeedStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::assignmentExplanation, JsonpDeserializer.stringDeserializer(), "assignment_explanation");
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id");
        op.add(Builder::node, DiscoveryNodeCompact._DESERIALIZER, "node");
        op.add(Builder::state, DatafeedState._DESERIALIZER, "state");
        op.add(Builder::timingStats, DatafeedTimingStats._DESERIALIZER, "timing_stats");
        op.add(Builder::runningState, DatafeedRunningState._DESERIALIZER, "running_state");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatafeedStats> {
        @Nullable
        private String assignmentExplanation;
        private String datafeedId;
        @Nullable
        private DiscoveryNodeCompact node;
        private DatafeedState state;
        @Nullable
        private DatafeedTimingStats timingStats;
        @Nullable
        private DatafeedRunningState runningState;

        public Builder() {
        }

        private Builder(DatafeedStats instance) {
            this.assignmentExplanation = instance.assignmentExplanation;
            this.datafeedId = instance.datafeedId;
            this.node = instance.node;
            this.state = instance.state;
            this.timingStats = instance.timingStats;
            this.runningState = instance.runningState;
        }

        public final Builder assignmentExplanation(@Nullable String value) {
            this.assignmentExplanation = value;
            return this;
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder node(@Nullable DiscoveryNodeCompact value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNodeCompact.Builder, ObjectBuilder<DiscoveryNodeCompact>> fn) {
            return this.node(fn.apply(new DiscoveryNodeCompact.Builder()).build());
        }

        public final Builder state(DatafeedState value) {
            this.state = value;
            return this;
        }

        public final Builder timingStats(@Nullable DatafeedTimingStats value) {
            this.timingStats = value;
            return this;
        }

        public final Builder timingStats(Function<DatafeedTimingStats.Builder, ObjectBuilder<DatafeedTimingStats>> fn) {
            return this.timingStats(fn.apply(new DatafeedTimingStats.Builder()).build());
        }

        public final Builder runningState(@Nullable DatafeedRunningState value) {
            this.runningState = value;
            return this;
        }

        public final Builder runningState(Function<DatafeedRunningState.Builder, ObjectBuilder<DatafeedRunningState>> fn) {
            return this.runningState(fn.apply(new DatafeedRunningState.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatafeedStats build() {
            this._checkSingleUse();
            return new DatafeedStats(this);
        }
    }
}

