/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.GeoResults;
import co.elastic.clients.elasticsearch.ml.Influence;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnomalyCause
implements JsonpSerializable {
    private final List<Double> actual;
    @Nullable
    private final String byFieldName;
    @Nullable
    private final String byFieldValue;
    @Nullable
    private final String correlatedByFieldValue;
    @Nullable
    private final String fieldName;
    @Nullable
    private final String function;
    @Nullable
    private final String functionDescription;
    @Nullable
    private final GeoResults geoResults;
    private final List<Influence> influencers;
    @Nullable
    private final String overFieldName;
    @Nullable
    private final String overFieldValue;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final String partitionFieldValue;
    private final double probability;
    private final List<Double> typical;
    public static final JsonpDeserializer<AnomalyCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyCause::setupAnomalyCauseDeserializer);

    private AnomalyCause(Builder builder) {
        this.actual = ApiTypeHelper.unmodifiable(builder.actual);
        this.byFieldName = builder.byFieldName;
        this.byFieldValue = builder.byFieldValue;
        this.correlatedByFieldValue = builder.correlatedByFieldValue;
        this.fieldName = builder.fieldName;
        this.function = builder.function;
        this.functionDescription = builder.functionDescription;
        this.geoResults = builder.geoResults;
        this.influencers = ApiTypeHelper.unmodifiable(builder.influencers);
        this.overFieldName = builder.overFieldName;
        this.overFieldValue = builder.overFieldValue;
        this.partitionFieldName = builder.partitionFieldName;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, (Object)this, "probability", 0.0);
        this.typical = ApiTypeHelper.unmodifiable(builder.typical);
    }

    public static AnomalyCause of(Function<Builder, ObjectBuilder<AnomalyCause>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Double> actual() {
        return this.actual;
    }

    @Nullable
    public final String byFieldName() {
        return this.byFieldName;
    }

    @Nullable
    public final String byFieldValue() {
        return this.byFieldValue;
    }

    @Nullable
    public final String correlatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    @Nullable
    public final String fieldName() {
        return this.fieldName;
    }

    @Nullable
    public final String function() {
        return this.function;
    }

    @Nullable
    public final String functionDescription() {
        return this.functionDescription;
    }

    @Nullable
    public final GeoResults geoResults() {
        return this.geoResults;
    }

    public final List<Influence> influencers() {
        return this.influencers;
    }

    @Nullable
    public final String overFieldName() {
        return this.overFieldName;
    }

    @Nullable
    public final String overFieldValue() {
        return this.overFieldValue;
    }

    @Nullable
    public final String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public final String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public final double probability() {
        return this.probability;
    }

    public final List<Double> typical() {
        return this.typical;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actual)) {
            generator.writeKey("actual");
            generator.writeStartArray();
            for (Double d : this.actual) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        if (this.byFieldName != null) {
            generator.writeKey("by_field_name");
            generator.write(this.byFieldName);
        }
        if (this.byFieldValue != null) {
            generator.writeKey("by_field_value");
            generator.write(this.byFieldValue);
        }
        if (this.correlatedByFieldValue != null) {
            generator.writeKey("correlated_by_field_value");
            generator.write(this.correlatedByFieldValue);
        }
        if (this.fieldName != null) {
            generator.writeKey("field_name");
            generator.write(this.fieldName);
        }
        if (this.function != null) {
            generator.writeKey("function");
            generator.write(this.function);
        }
        if (this.functionDescription != null) {
            generator.writeKey("function_description");
            generator.write(this.functionDescription);
        }
        if (this.geoResults != null) {
            generator.writeKey("geo_results");
            this.geoResults.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.influencers)) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (Influence influence : this.influencers) {
                influence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.overFieldName != null) {
            generator.writeKey("over_field_name");
            generator.write(this.overFieldName);
        }
        if (this.overFieldValue != null) {
            generator.writeKey("over_field_value");
            generator.write(this.overFieldValue);
        }
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            generator.writeKey("partition_field_value");
            generator.write(this.partitionFieldValue);
        }
        generator.writeKey("probability");
        generator.write(this.probability);
        if (ApiTypeHelper.isDefined(this.typical)) {
            generator.writeKey("typical");
            generator.writeStartArray();
            for (Double d : this.typical) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAnomalyCauseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actual, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "actual");
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name");
        op.add(Builder::byFieldValue, JsonpDeserializer.stringDeserializer(), "by_field_value");
        op.add(Builder::correlatedByFieldValue, JsonpDeserializer.stringDeserializer(), "correlated_by_field_value");
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name");
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function");
        op.add(Builder::functionDescription, JsonpDeserializer.stringDeserializer(), "function_description");
        op.add(Builder::geoResults, GeoResults._DESERIALIZER, "geo_results");
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influence._DESERIALIZER), "influencers");
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name");
        op.add(Builder::overFieldValue, JsonpDeserializer.stringDeserializer(), "over_field_value");
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name");
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value");
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::typical, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "typical");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnomalyCause> {
        @Nullable
        private List<Double> actual;
        @Nullable
        private String byFieldName;
        @Nullable
        private String byFieldValue;
        @Nullable
        private String correlatedByFieldValue;
        @Nullable
        private String fieldName;
        @Nullable
        private String function;
        @Nullable
        private String functionDescription;
        @Nullable
        private GeoResults geoResults;
        @Nullable
        private List<Influence> influencers;
        @Nullable
        private String overFieldName;
        @Nullable
        private String overFieldValue;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private String partitionFieldValue;
        private Double probability;
        @Nullable
        private List<Double> typical;

        public Builder() {
        }

        private Builder(AnomalyCause instance) {
            this.actual = instance.actual;
            this.byFieldName = instance.byFieldName;
            this.byFieldValue = instance.byFieldValue;
            this.correlatedByFieldValue = instance.correlatedByFieldValue;
            this.fieldName = instance.fieldName;
            this.function = instance.function;
            this.functionDescription = instance.functionDescription;
            this.geoResults = instance.geoResults;
            this.influencers = instance.influencers;
            this.overFieldName = instance.overFieldName;
            this.overFieldValue = instance.overFieldValue;
            this.partitionFieldName = instance.partitionFieldName;
            this.partitionFieldValue = instance.partitionFieldValue;
            this.probability = instance.probability;
            this.typical = instance.typical;
        }

        public final Builder actual(List<Double> list) {
            this.actual = Builder._listAddAll(this.actual, list);
            return this;
        }

        public final Builder actual(Double value, Double ... values) {
            this.actual = Builder._listAdd(this.actual, value, values);
            return this;
        }

        public final Builder byFieldName(@Nullable String value) {
            this.byFieldName = value;
            return this;
        }

        public final Builder byFieldValue(@Nullable String value) {
            this.byFieldValue = value;
            return this;
        }

        public final Builder correlatedByFieldValue(@Nullable String value) {
            this.correlatedByFieldValue = value;
            return this;
        }

        public final Builder fieldName(@Nullable String value) {
            this.fieldName = value;
            return this;
        }

        public final Builder function(@Nullable String value) {
            this.function = value;
            return this;
        }

        public final Builder functionDescription(@Nullable String value) {
            this.functionDescription = value;
            return this;
        }

        public final Builder geoResults(@Nullable GeoResults value) {
            this.geoResults = value;
            return this;
        }

        public final Builder geoResults(Function<GeoResults.Builder, ObjectBuilder<GeoResults>> fn) {
            return this.geoResults(fn.apply(new GeoResults.Builder()).build());
        }

        public final Builder influencers(List<Influence> list) {
            this.influencers = Builder._listAddAll(this.influencers, list);
            return this;
        }

        public final Builder influencers(Influence value, Influence ... values) {
            this.influencers = Builder._listAdd(this.influencers, value, values);
            return this;
        }

        public final Builder influencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.influencers(fn.apply(new Influence.Builder()).build(), new Influence[0]);
        }

        public final Builder overFieldName(@Nullable String value) {
            this.overFieldName = value;
            return this;
        }

        public final Builder overFieldValue(@Nullable String value) {
            this.overFieldValue = value;
            return this;
        }

        public final Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public final Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder typical(List<Double> list) {
            this.typical = Builder._listAddAll(this.typical, list);
            return this;
        }

        public final Builder typical(Double value, Double ... values) {
            this.typical = Builder._listAdd(this.typical, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnomalyCause build() {
            this._checkSingleUse();
            return new AnomalyCause(this);
        }
    }
}

