/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.geo_ip_stats;

import co.elastic.clients.elasticsearch.ingest.geo_ip_stats.GeoIpNodeDatabaseName;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GeoIpNodeDatabases
implements JsonpSerializable {
    private final List<GeoIpNodeDatabaseName> databases;
    private final List<String> filesInTemp;
    public static final JsonpDeserializer<GeoIpNodeDatabases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpNodeDatabases::setupGeoIpNodeDatabasesDeserializer);

    private GeoIpNodeDatabases(Builder builder) {
        this.databases = ApiTypeHelper.unmodifiableRequired(builder.databases, (Object)this, "databases");
        this.filesInTemp = ApiTypeHelper.unmodifiableRequired(builder.filesInTemp, (Object)this, "filesInTemp");
    }

    public static GeoIpNodeDatabases of(Function<Builder, ObjectBuilder<GeoIpNodeDatabases>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<GeoIpNodeDatabaseName> databases() {
        return this.databases;
    }

    public final List<String> filesInTemp() {
        return this.filesInTemp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.databases)) {
            generator.writeKey("databases");
            generator.writeStartArray();
            for (GeoIpNodeDatabaseName geoIpNodeDatabaseName : this.databases) {
                geoIpNodeDatabaseName.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.filesInTemp)) {
            generator.writeKey("files_in_temp");
            generator.writeStartArray();
            for (String string : this.filesInTemp) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoIpNodeDatabasesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::databases, JsonpDeserializer.arrayDeserializer(GeoIpNodeDatabaseName._DESERIALIZER), "databases");
        op.add(Builder::filesInTemp, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "files_in_temp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoIpNodeDatabases> {
        private List<GeoIpNodeDatabaseName> databases;
        private List<String> filesInTemp;

        public Builder() {
        }

        private Builder(GeoIpNodeDatabases instance) {
            this.databases = instance.databases;
            this.filesInTemp = instance.filesInTemp;
        }

        public final Builder databases(List<GeoIpNodeDatabaseName> list) {
            this.databases = Builder._listAddAll(this.databases, list);
            return this;
        }

        public final Builder databases(GeoIpNodeDatabaseName value, GeoIpNodeDatabaseName ... values) {
            this.databases = Builder._listAdd(this.databases, value, values);
            return this;
        }

        public final Builder databases(Function<GeoIpNodeDatabaseName.Builder, ObjectBuilder<GeoIpNodeDatabaseName>> fn) {
            return this.databases(fn.apply(new GeoIpNodeDatabaseName.Builder()).build(), new GeoIpNodeDatabaseName[0]);
        }

        public final Builder filesInTemp(List<String> list) {
            this.filesInTemp = Builder._listAddAll(this.filesInTemp, list);
            return this;
        }

        public final Builder filesInTemp(String value, String ... values) {
            this.filesInTemp = Builder._listAdd(this.filesInTemp, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoIpNodeDatabases build() {
            this._checkSingleUse();
            return new GeoIpNodeDatabases(this);
        }
    }
}

