/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.FingerprintDigest;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FingerprintProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> fields;
    @Nullable
    private final String targetField;
    @Nullable
    private final String salt;
    @Nullable
    private final FingerprintDigest method;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<FingerprintProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintProcessor::setupFingerprintProcessorDeserializer);

    private FingerprintProcessor(Builder builder) {
        super(builder);
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.targetField = builder.targetField;
        this.salt = builder.salt;
        this.method = builder.method;
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static FingerprintProcessor of(Function<Builder, ObjectBuilder<FingerprintProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Fingerprint;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String salt() {
        return this.salt;
    }

    @Nullable
    public final FingerprintDigest method() {
        return this.method;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.salt != null) {
            generator.writeKey("salt");
            generator.write(this.salt);
        }
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFingerprintProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::salt, JsonpDeserializer.stringDeserializer(), "salt");
        op.add(Builder::method, FingerprintDigest._DESERIALIZER, "method");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FingerprintProcessor> {
        private List<String> fields;
        @Nullable
        private String targetField;
        @Nullable
        private String salt;
        @Nullable
        private FingerprintDigest method;
        @Nullable
        private Boolean ignoreMissing;

        public Builder() {
        }

        private Builder(FingerprintProcessor instance) {
            this.fields = instance.fields;
            this.targetField = instance.targetField;
            this.salt = instance.salt;
            this.method = instance.method;
            this.ignoreMissing = instance.ignoreMissing;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder salt(@Nullable String value) {
            this.salt = value;
            return this;
        }

        public final Builder method(@Nullable FingerprintDigest value) {
            this.method = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FingerprintProcessor build() {
            this._checkSingleUse();
            return new FingerprintProcessor(this);
        }
    }
}

