/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FailProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String message;
    public static final JsonpDeserializer<FailProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FailProcessor::setupFailProcessorDeserializer);

    private FailProcessor(Builder builder) {
        super(builder);
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
    }

    public static FailProcessor of(Function<Builder, ObjectBuilder<FailProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Fail;
    }

    public final String message() {
        return this.message;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("message");
        generator.write(this.message);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFailProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FailProcessor> {
        private String message;

        public Builder() {
        }

        private Builder(FailProcessor instance) {
            this.message = instance.message;
        }

        public final Builder message(String value) {
            this.message = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FailProcessor build() {
            this._checkSingleUse();
            return new FailProcessor(this);
        }
    }
}

