/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CommunityIDProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final String sourceIp;
    @Nullable
    private final String sourcePort;
    @Nullable
    private final String destinationIp;
    @Nullable
    private final String destinationPort;
    @Nullable
    private final String ianaNumber;
    @Nullable
    private final String icmpType;
    @Nullable
    private final String icmpCode;
    @Nullable
    private final String transport;
    @Nullable
    private final String targetField;
    @Nullable
    private final Integer seed;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<CommunityIDProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CommunityIDProcessor::setupCommunityIDProcessorDeserializer);

    private CommunityIDProcessor(Builder builder) {
        super(builder);
        this.sourceIp = builder.sourceIp;
        this.sourcePort = builder.sourcePort;
        this.destinationIp = builder.destinationIp;
        this.destinationPort = builder.destinationPort;
        this.ianaNumber = builder.ianaNumber;
        this.icmpType = builder.icmpType;
        this.icmpCode = builder.icmpCode;
        this.transport = builder.transport;
        this.targetField = builder.targetField;
        this.seed = builder.seed;
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static CommunityIDProcessor of(Function<Builder, ObjectBuilder<CommunityIDProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.CommunityId;
    }

    @Nullable
    public final String sourceIp() {
        return this.sourceIp;
    }

    @Nullable
    public final String sourcePort() {
        return this.sourcePort;
    }

    @Nullable
    public final String destinationIp() {
        return this.destinationIp;
    }

    @Nullable
    public final String destinationPort() {
        return this.destinationPort;
    }

    @Nullable
    public final String ianaNumber() {
        return this.ianaNumber;
    }

    @Nullable
    public final String icmpType() {
        return this.icmpType;
    }

    @Nullable
    public final String icmpCode() {
        return this.icmpCode;
    }

    @Nullable
    public final String transport() {
        return this.transport;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final Integer seed() {
        return this.seed;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.sourceIp != null) {
            generator.writeKey("source_ip");
            generator.write(this.sourceIp);
        }
        if (this.sourcePort != null) {
            generator.writeKey("source_port");
            generator.write(this.sourcePort);
        }
        if (this.destinationIp != null) {
            generator.writeKey("destination_ip");
            generator.write(this.destinationIp);
        }
        if (this.destinationPort != null) {
            generator.writeKey("destination_port");
            generator.write(this.destinationPort);
        }
        if (this.ianaNumber != null) {
            generator.writeKey("iana_number");
            generator.write(this.ianaNumber);
        }
        if (this.icmpType != null) {
            generator.writeKey("icmp_type");
            generator.write(this.icmpType);
        }
        if (this.icmpCode != null) {
            generator.writeKey("icmp_code");
            generator.write(this.icmpCode);
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            generator.write(this.transport);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.seed != null) {
            generator.writeKey("seed");
            generator.write(this.seed.intValue());
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCommunityIDProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::sourceIp, JsonpDeserializer.stringDeserializer(), "source_ip");
        op.add(Builder::sourcePort, JsonpDeserializer.stringDeserializer(), "source_port");
        op.add(Builder::destinationIp, JsonpDeserializer.stringDeserializer(), "destination_ip");
        op.add(Builder::destinationPort, JsonpDeserializer.stringDeserializer(), "destination_port");
        op.add(Builder::ianaNumber, JsonpDeserializer.stringDeserializer(), "iana_number");
        op.add(Builder::icmpType, JsonpDeserializer.stringDeserializer(), "icmp_type");
        op.add(Builder::icmpCode, JsonpDeserializer.stringDeserializer(), "icmp_code");
        op.add(Builder::transport, JsonpDeserializer.stringDeserializer(), "transport");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::seed, JsonpDeserializer.integerDeserializer(), "seed");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CommunityIDProcessor> {
        @Nullable
        private String sourceIp;
        @Nullable
        private String sourcePort;
        @Nullable
        private String destinationIp;
        @Nullable
        private String destinationPort;
        @Nullable
        private String ianaNumber;
        @Nullable
        private String icmpType;
        @Nullable
        private String icmpCode;
        @Nullable
        private String transport;
        @Nullable
        private String targetField;
        @Nullable
        private Integer seed;
        @Nullable
        private Boolean ignoreMissing;

        public Builder() {
        }

        private Builder(CommunityIDProcessor instance) {
            this.sourceIp = instance.sourceIp;
            this.sourcePort = instance.sourcePort;
            this.destinationIp = instance.destinationIp;
            this.destinationPort = instance.destinationPort;
            this.ianaNumber = instance.ianaNumber;
            this.icmpType = instance.icmpType;
            this.icmpCode = instance.icmpCode;
            this.transport = instance.transport;
            this.targetField = instance.targetField;
            this.seed = instance.seed;
            this.ignoreMissing = instance.ignoreMissing;
        }

        public final Builder sourceIp(@Nullable String value) {
            this.sourceIp = value;
            return this;
        }

        public final Builder sourcePort(@Nullable String value) {
            this.sourcePort = value;
            return this;
        }

        public final Builder destinationIp(@Nullable String value) {
            this.destinationIp = value;
            return this;
        }

        public final Builder destinationPort(@Nullable String value) {
            this.destinationPort = value;
            return this;
        }

        public final Builder ianaNumber(@Nullable String value) {
            this.ianaNumber = value;
            return this;
        }

        public final Builder icmpType(@Nullable String value) {
            this.icmpType = value;
            return this;
        }

        public final Builder icmpCode(@Nullable String value) {
            this.icmpCode = value;
            return this;
        }

        public final Builder transport(@Nullable String value) {
            this.transport = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder seed(@Nullable Integer value) {
            this.seed = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CommunityIDProcessor build() {
            this._checkSingleUse();
            return new CommunityIDProcessor(this);
        }
    }
}

