/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.OpenShiftAiServiceSettings;
import co.elastic.clients.elasticsearch.inference.OpenShiftAiServiceType;
import co.elastic.clients.elasticsearch.inference.OpenShiftAiTaskSettings;
import co.elastic.clients.elasticsearch.inference.OpenShiftAiTaskType;
import co.elastic.clients.elasticsearch.inference.PutOpenshiftAiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutOpenshiftAiRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String openshiftaiInferenceId;
    private final OpenShiftAiServiceType service;
    private final OpenShiftAiServiceSettings serviceSettings;
    @Nullable
    private final OpenShiftAiTaskSettings taskSettings;
    private final OpenShiftAiTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutOpenshiftAiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutOpenshiftAiRequest::setupPutOpenshiftAiRequestDeserializer);
    public static final Endpoint<PutOpenshiftAiRequest, PutOpenshiftAiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutOpenshiftAiRequest, PutOpenshiftAiResponse>("es/inference.put_openshift_ai", request -> "PUT", request -> {
        boolean _openshiftaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.openshiftaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _openshiftaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("openshiftaiInferenceId", request.openshiftaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutOpenshiftAiResponse._DESERIALIZER);

    private PutOpenshiftAiRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.openshiftaiInferenceId = ApiTypeHelper.requireNonNull(builder.openshiftaiInferenceId, this, "openshiftaiInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutOpenshiftAiRequest of(Function<Builder, ObjectBuilder<PutOpenshiftAiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String openshiftaiInferenceId() {
        return this.openshiftaiInferenceId;
    }

    public final OpenShiftAiServiceType service() {
        return this.service;
    }

    public final OpenShiftAiServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final OpenShiftAiTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final OpenShiftAiTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutOpenshiftAiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, OpenShiftAiServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, OpenShiftAiServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, OpenShiftAiTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutOpenshiftAiRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String openshiftaiInferenceId;
        private OpenShiftAiServiceType service;
        private OpenShiftAiServiceSettings serviceSettings;
        @Nullable
        private OpenShiftAiTaskSettings taskSettings;
        private OpenShiftAiTaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutOpenshiftAiRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.openshiftaiInferenceId = instance.openshiftaiInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder openshiftaiInferenceId(String value) {
            this.openshiftaiInferenceId = value;
            return this;
        }

        public final Builder service(OpenShiftAiServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(OpenShiftAiServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<OpenShiftAiServiceSettings.Builder, ObjectBuilder<OpenShiftAiServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new OpenShiftAiServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable OpenShiftAiTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<OpenShiftAiTaskSettings.Builder, ObjectBuilder<OpenShiftAiTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new OpenShiftAiTaskSettings.Builder()).build());
        }

        public final Builder taskType(OpenShiftAiTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutOpenshiftAiRequest build() {
            this._checkSingleUse();
            return new PutOpenshiftAiRequest(this);
        }
    }
}

