/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.OpenAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.OpenAIServiceType;
import co.elastic.clients.elasticsearch.inference.OpenAITaskSettings;
import co.elastic.clients.elasticsearch.inference.OpenAITaskType;
import co.elastic.clients.elasticsearch.inference.PutOpenaiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutOpenaiRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String openaiInferenceId;
    private final OpenAIServiceType service;
    private final OpenAIServiceSettings serviceSettings;
    @Nullable
    private final OpenAITaskSettings taskSettings;
    private final OpenAITaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutOpenaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutOpenaiRequest::setupPutOpenaiRequestDeserializer);
    public static final Endpoint<PutOpenaiRequest, PutOpenaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutOpenaiRequest, PutOpenaiResponse>("es/inference.put_openai", request -> "PUT", request -> {
        boolean _openaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.openaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _openaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("openaiInferenceId", request.openaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutOpenaiResponse._DESERIALIZER);

    private PutOpenaiRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.openaiInferenceId = ApiTypeHelper.requireNonNull(builder.openaiInferenceId, this, "openaiInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutOpenaiRequest of(Function<Builder, ObjectBuilder<PutOpenaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String openaiInferenceId() {
        return this.openaiInferenceId;
    }

    public final OpenAIServiceType service() {
        return this.service;
    }

    public final OpenAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final OpenAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final OpenAITaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutOpenaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, OpenAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, OpenAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, OpenAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutOpenaiRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String openaiInferenceId;
        private OpenAIServiceType service;
        private OpenAIServiceSettings serviceSettings;
        @Nullable
        private OpenAITaskSettings taskSettings;
        private OpenAITaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutOpenaiRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.openaiInferenceId = instance.openaiInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder openaiInferenceId(String value) {
            this.openaiInferenceId = value;
            return this;
        }

        public final Builder service(OpenAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(OpenAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<OpenAIServiceSettings.Builder, ObjectBuilder<OpenAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new OpenAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable OpenAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<OpenAITaskSettings.Builder, ObjectBuilder<OpenAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new OpenAITaskSettings.Builder()).build());
        }

        public final Builder taskType(OpenAITaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutOpenaiRequest build() {
            this._checkSingleUse();
            return new PutOpenaiRequest(this);
        }
    }
}

