/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.NvidiaServiceSettings;
import co.elastic.clients.elasticsearch.inference.NvidiaServiceType;
import co.elastic.clients.elasticsearch.inference.NvidiaTaskSettings;
import co.elastic.clients.elasticsearch.inference.NvidiaTaskType;
import co.elastic.clients.elasticsearch.inference.PutNvidiaResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutNvidiaRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String nvidiaInferenceId;
    private final NvidiaServiceType service;
    private final NvidiaServiceSettings serviceSettings;
    @Nullable
    private final NvidiaTaskSettings taskSettings;
    private final NvidiaTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutNvidiaRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutNvidiaRequest::setupPutNvidiaRequestDeserializer);
    public static final Endpoint<PutNvidiaRequest, PutNvidiaResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutNvidiaRequest, PutNvidiaResponse>("es/inference.put_nvidia", request -> "PUT", request -> {
        boolean _taskType = true;
        int _nvidiaInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nvidiaInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _taskType = true;
        int _nvidiaInferenceId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("nvidiaInferenceId", request.nvidiaInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutNvidiaResponse._DESERIALIZER);

    private PutNvidiaRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.nvidiaInferenceId = ApiTypeHelper.requireNonNull(builder.nvidiaInferenceId, this, "nvidiaInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutNvidiaRequest of(Function<Builder, ObjectBuilder<PutNvidiaRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String nvidiaInferenceId() {
        return this.nvidiaInferenceId;
    }

    public final NvidiaServiceType service() {
        return this.service;
    }

    public final NvidiaServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final NvidiaTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final NvidiaTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutNvidiaRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, NvidiaServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, NvidiaServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, NvidiaTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutNvidiaRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String nvidiaInferenceId;
        private NvidiaServiceType service;
        private NvidiaServiceSettings serviceSettings;
        @Nullable
        private NvidiaTaskSettings taskSettings;
        private NvidiaTaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutNvidiaRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.nvidiaInferenceId = instance.nvidiaInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder nvidiaInferenceId(String value) {
            this.nvidiaInferenceId = value;
            return this;
        }

        public final Builder service(NvidiaServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(NvidiaServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<NvidiaServiceSettings.Builder, ObjectBuilder<NvidiaServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new NvidiaServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable NvidiaTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<NvidiaTaskSettings.Builder, ObjectBuilder<NvidiaTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new NvidiaTaskSettings.Builder()).build());
        }

        public final Builder taskType(NvidiaTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutNvidiaRequest build() {
            this._checkSingleUse();
            return new PutNvidiaRequest(this);
        }
    }
}

