/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.AmazonSageMakerServiceSettings;
import co.elastic.clients.elasticsearch.inference.AmazonSageMakerServiceType;
import co.elastic.clients.elasticsearch.inference.AmazonSageMakerTaskSettings;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAmazonsagemakerResponse;
import co.elastic.clients.elasticsearch.inference.TaskTypeAmazonSageMaker;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAmazonsagemakerRequest
extends RequestBase
implements JsonpSerializable {
    private final String amazonsagemakerInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AmazonSageMakerServiceType service;
    private final AmazonSageMakerServiceSettings serviceSettings;
    @Nullable
    private final AmazonSageMakerTaskSettings taskSettings;
    private final TaskTypeAmazonSageMaker taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAmazonsagemakerRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAmazonsagemakerRequest::setupPutAmazonsagemakerRequestDeserializer);
    public static final Endpoint<PutAmazonsagemakerRequest, PutAmazonsagemakerResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAmazonsagemakerRequest, PutAmazonsagemakerResponse>("es/inference.put_amazonsagemaker", request -> "PUT", request -> {
        boolean _amazonsagemakerInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.amazonsagemakerInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _amazonsagemakerInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("amazonsagemakerInferenceId", request.amazonsagemakerInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAmazonsagemakerResponse._DESERIALIZER);

    private PutAmazonsagemakerRequest(Builder builder) {
        this.amazonsagemakerInferenceId = ApiTypeHelper.requireNonNull(builder.amazonsagemakerInferenceId, this, "amazonsagemakerInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAmazonsagemakerRequest of(Function<Builder, ObjectBuilder<PutAmazonsagemakerRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String amazonsagemakerInferenceId() {
        return this.amazonsagemakerInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AmazonSageMakerServiceType service() {
        return this.service;
    }

    public final AmazonSageMakerServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AmazonSageMakerTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final TaskTypeAmazonSageMaker taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutAmazonsagemakerRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AmazonSageMakerServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AmazonSageMakerServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AmazonSageMakerTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAmazonsagemakerRequest> {
        private String amazonsagemakerInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AmazonSageMakerServiceType service;
        private AmazonSageMakerServiceSettings serviceSettings;
        @Nullable
        private AmazonSageMakerTaskSettings taskSettings;
        private TaskTypeAmazonSageMaker taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutAmazonsagemakerRequest instance) {
            this.amazonsagemakerInferenceId = instance.amazonsagemakerInferenceId;
            this.chunkingSettings = instance.chunkingSettings;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder amazonsagemakerInferenceId(String value) {
            this.amazonsagemakerInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AmazonSageMakerServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AmazonSageMakerServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AmazonSageMakerServiceSettings.Builder, ObjectBuilder<AmazonSageMakerServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AmazonSageMakerServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AmazonSageMakerTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AmazonSageMakerTaskSettings.Builder, ObjectBuilder<AmazonSageMakerTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AmazonSageMakerTaskSettings.Builder()).build());
        }

        public final Builder taskType(TaskTypeAmazonSageMaker value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAmazonsagemakerRequest build() {
            this._checkSingleUse();
            return new PutAmazonsagemakerRequest(this);
        }
    }
}

