/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenShiftAiTaskSettings
implements JsonpSerializable {
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<OpenShiftAiTaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenShiftAiTaskSettings::setupOpenShiftAiTaskSettingsDeserializer);

    private OpenShiftAiTaskSettings(Builder builder) {
        this.returnDocuments = builder.returnDocuments;
        this.topN = builder.topN;
    }

    public static OpenShiftAiTaskSettings of(Function<Builder, ObjectBuilder<OpenShiftAiTaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments.booleanValue());
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupOpenShiftAiTaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenShiftAiTaskSettings> {
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private Integer topN;

        public Builder() {
        }

        private Builder(OpenShiftAiTaskSettings instance) {
            this.returnDocuments = instance.returnDocuments;
            this.topN = instance.topN;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenShiftAiTaskSettings build() {
            this._checkSingleUse();
            return new OpenShiftAiTaskSettings(this);
        }
    }
}

