/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DeepSeekServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String modelId;
    @Nullable
    private final String url;
    public static final JsonpDeserializer<DeepSeekServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeepSeekServiceSettings::setupDeepSeekServiceSettingsDeserializer);

    private DeepSeekServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.url = builder.url;
    }

    public static DeepSeekServiceSettings of(Function<Builder, ObjectBuilder<DeepSeekServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String url() {
        return this.url;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.url != null) {
            generator.writeKey("url");
            generator.write(this.url);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDeepSeekServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::url, JsonpDeserializer.stringDeserializer(), "url");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DeepSeekServiceSettings> {
        private String apiKey;
        private String modelId;
        @Nullable
        private String url;

        public Builder() {
        }

        private Builder(DeepSeekServiceSettings instance) {
            this.apiKey = instance.apiKey;
            this.modelId = instance.modelId;
            this.url = instance.url;
        }

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeepSeekServiceSettings build() {
            this._checkSingleUse();
            return new DeepSeekServiceSettings(this);
        }
    }
}

