/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ContextualAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final String instruction;
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final Integer topK;
    public static final JsonpDeserializer<ContextualAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ContextualAITaskSettings::setupContextualAITaskSettingsDeserializer);

    private ContextualAITaskSettings(Builder builder) {
        this.instruction = builder.instruction;
        this.returnDocuments = builder.returnDocuments;
        this.topK = builder.topK;
    }

    public static ContextualAITaskSettings of(Function<Builder, ObjectBuilder<ContextualAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String instruction() {
        return this.instruction;
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final Integer topK() {
        return this.topK;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.instruction != null) {
            generator.writeKey("instruction");
            generator.write(this.instruction);
        }
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments.booleanValue());
        }
        if (this.topK != null) {
            generator.writeKey("top_k");
            generator.write(this.topK.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupContextualAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::instruction, JsonpDeserializer.stringDeserializer(), "instruction");
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::topK, JsonpDeserializer.integerDeserializer(), "top_k");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ContextualAITaskSettings> {
        @Nullable
        private String instruction;
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private Integer topK;

        public Builder() {
        }

        private Builder(ContextualAITaskSettings instance) {
            this.instruction = instance.instruction;
            this.returnDocuments = instance.returnDocuments;
            this.topK = instance.topK;
        }

        public final Builder instruction(@Nullable String value) {
            this.instruction = value;
            return this;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder topK(@Nullable Integer value) {
            this.topK = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ContextualAITaskSettings build() {
            this._checkSingleUse();
            return new ContextualAITaskSettings(this);
        }
    }
}

