/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.put_data_stream_mappings;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdatedDataStreamMappings
implements JsonpSerializable {
    private final String name;
    private final boolean appliedToDataStream;
    @Nullable
    private final String error;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final TypeMapping effectiveMappings;
    public static final JsonpDeserializer<UpdatedDataStreamMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdatedDataStreamMappings::setupUpdatedDataStreamMappingsDeserializer);

    private UpdatedDataStreamMappings(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.appliedToDataStream = ApiTypeHelper.requireNonNull(builder.appliedToDataStream, (Object)this, "appliedToDataStream", false);
        this.error = builder.error;
        this.mappings = builder.mappings;
        this.effectiveMappings = builder.effectiveMappings;
    }

    public static UpdatedDataStreamMappings of(Function<Builder, ObjectBuilder<UpdatedDataStreamMappings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final boolean appliedToDataStream() {
        return this.appliedToDataStream;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public final TypeMapping effectiveMappings() {
        return this.effectiveMappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("applied_to_data_stream");
        generator.write(this.appliedToDataStream);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.effectiveMappings != null) {
            generator.writeKey("effective_mappings");
            this.effectiveMappings.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdatedDataStreamMappingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::appliedToDataStream, JsonpDeserializer.booleanDeserializer(), "applied_to_data_stream");
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::effectiveMappings, TypeMapping._DESERIALIZER, "effective_mappings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UpdatedDataStreamMappings> {
        private String name;
        private Boolean appliedToDataStream;
        @Nullable
        private String error;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private TypeMapping effectiveMappings;

        public Builder() {
        }

        private Builder(UpdatedDataStreamMappings instance) {
            this.name = instance.name;
            this.appliedToDataStream = instance.appliedToDataStream;
            this.error = instance.error;
            this.mappings = instance.mappings;
            this.effectiveMappings = instance.effectiveMappings;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder appliedToDataStream(boolean value) {
            this.appliedToDataStream = value;
            return this;
        }

        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder effectiveMappings(@Nullable TypeMapping value) {
            this.effectiveMappings = value;
            return this;
        }

        public final Builder effectiveMappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.effectiveMappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdatedDataStreamMappings build() {
            this._checkSingleUse();
            return new UpdatedDataStreamMappings(this);
        }
    }
}

