/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_field_mapping;

import co.elastic.clients.elasticsearch._types.mapping.FieldMapping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TypeFieldMappings
implements JsonpSerializable {
    private final Map<String, FieldMapping> mappings;
    public static final JsonpDeserializer<TypeFieldMappings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TypeFieldMappings::setupTypeFieldMappingsDeserializer);

    private TypeFieldMappings(Builder builder) {
        this.mappings = ApiTypeHelper.unmodifiableRequired(builder.mappings, (Object)this, "mappings");
    }

    public static TypeFieldMappings of(Function<Builder, ObjectBuilder<TypeFieldMappings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, FieldMapping> mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.mappings)) {
            generator.writeKey("mappings");
            generator.writeStartObject();
            for (Map.Entry<String, FieldMapping> item0 : this.mappings.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTypeFieldMappingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mappings, JsonpDeserializer.stringMapDeserializer(FieldMapping._DESERIALIZER), "mappings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TypeFieldMappings> {
        private Map<String, FieldMapping> mappings;

        public Builder() {
        }

        private Builder(TypeFieldMappings instance) {
            this.mappings = instance.mappings;
        }

        public final Builder mappings(Map<String, FieldMapping> map) {
            this.mappings = Builder._mapPutAll(this.mappings, map);
            return this;
        }

        public final Builder mappings(String key, FieldMapping value) {
            this.mappings = Builder._mapPut(this.mappings, key, value);
            return this;
        }

        public final Builder mappings(String key, Function<FieldMapping.Builder, ObjectBuilder<FieldMapping>> fn) {
            return this.mappings(key, fn.apply(new FieldMapping.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TypeFieldMappings build() {
            this._checkSingleUse();
            return new TypeFieldMappings(this);
        }
    }
}

