/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_stream_options;

import co.elastic.clients.elasticsearch.indices.DataStreamOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamWithOptions
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final DataStreamOptions options;
    public static final JsonpDeserializer<DataStreamWithOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamWithOptions::setupDataStreamWithOptionsDeserializer);

    private DataStreamWithOptions(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.options = builder.options;
    }

    public static DataStreamWithOptions of(Function<Builder, ObjectBuilder<DataStreamWithOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final DataStreamOptions options() {
        return this.options;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.options != null) {
            generator.writeKey("options");
            this.options.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamWithOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::options, DataStreamOptions._DESERIALIZER, "options");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamWithOptions> {
        private String name;
        @Nullable
        private DataStreamOptions options;

        public Builder() {
        }

        private Builder(DataStreamWithOptions instance) {
            this.name = instance.name;
            this.options = instance.options;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder options(@Nullable DataStreamOptions value) {
            this.options = value;
            return this;
        }

        public final Builder options(Function<DataStreamOptions.Builder, ObjectBuilder<DataStreamOptions>> fn) {
            return this.options(fn.apply(new DataStreamOptions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamWithOptions build() {
            this._checkSingleUse();
            return new DataStreamWithOptions(this);
        }
    }
}

