/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarity;
import co.elastic.clients.elasticsearch.indices.SettingsSimilarityVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SettingsSimilarityScripted
implements SettingsSimilarityVariant,
JsonpSerializable {
    private final Script script;
    @Nullable
    private final Script weightScript;
    public static final JsonpDeserializer<SettingsSimilarityScripted> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SettingsSimilarityScripted::setupSettingsSimilarityScriptedDeserializer);

    private SettingsSimilarityScripted(Builder builder) {
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.weightScript = builder.weightScript;
    }

    public static SettingsSimilarityScripted of(Function<Builder, ObjectBuilder<SettingsSimilarityScripted>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SettingsSimilarity.Kind _settingsSimilarityKind() {
        return SettingsSimilarity.Kind.Scripted;
    }

    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Script weightScript() {
        return this.weightScript;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "scripted");
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        if (this.weightScript != null) {
            generator.writeKey("weight_script");
            this.weightScript.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSettingsSimilarityScriptedDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::weightScript, Script._DESERIALIZER, "weight_script");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SettingsSimilarityScripted> {
        private Script script;
        @Nullable
        private Script weightScript;

        public Builder() {
        }

        private Builder(SettingsSimilarityScripted instance) {
            this.script = instance.script;
            this.weightScript = instance.weightScript;
        }

        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder weightScript(@Nullable Script value) {
            this.weightScript = value;
            return this;
        }

        public final Builder weightScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.weightScript(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SettingsSimilarityScripted build() {
            this._checkSingleUse();
            return new SettingsSimilarityScripted(this);
        }
    }
}

