/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamplingConfiguration
implements JsonpSerializable {
    private final double rate;
    private final int maxSamples;
    @Nullable
    private final String maxSize;
    private final long maxSizeInBytes;
    @Nullable
    private final Time timeToLive;
    private final long timeToLiveInMillis;
    @Nullable
    private final String if_;
    @Nullable
    private final DateTime creationTime;
    private final long creationTimeInMillis;
    public static final JsonpDeserializer<SamplingConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamplingConfiguration::setupSamplingConfigurationDeserializer);

    private SamplingConfiguration(Builder builder) {
        this.rate = ApiTypeHelper.requireNonNull(builder.rate, (Object)this, "rate", 0.0);
        this.maxSamples = ApiTypeHelper.requireNonNull(builder.maxSamples, (Object)this, "maxSamples", 0);
        this.maxSize = builder.maxSize;
        this.maxSizeInBytes = ApiTypeHelper.requireNonNull(builder.maxSizeInBytes, (Object)this, "maxSizeInBytes", 0L);
        this.timeToLive = builder.timeToLive;
        this.timeToLiveInMillis = ApiTypeHelper.requireNonNull(builder.timeToLiveInMillis, (Object)this, "timeToLiveInMillis", 0L);
        this.if_ = builder.if_;
        this.creationTime = builder.creationTime;
        this.creationTimeInMillis = ApiTypeHelper.requireNonNull(builder.creationTimeInMillis, (Object)this, "creationTimeInMillis", 0L);
    }

    public static SamplingConfiguration of(Function<Builder, ObjectBuilder<SamplingConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double rate() {
        return this.rate;
    }

    public final int maxSamples() {
        return this.maxSamples;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    public final long maxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    @Nullable
    public final Time timeToLive() {
        return this.timeToLive;
    }

    public final long timeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    @Nullable
    public final String if_() {
        return this.if_;
    }

    @Nullable
    public final DateTime creationTime() {
        return this.creationTime;
    }

    public final long creationTimeInMillis() {
        return this.creationTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rate");
        generator.write(this.rate);
        generator.writeKey("max_samples");
        generator.write(this.maxSamples);
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        generator.writeKey("max_size_in_bytes");
        generator.write(this.maxSizeInBytes);
        if (this.timeToLive != null) {
            generator.writeKey("time_to_live");
            this.timeToLive.serialize(generator, mapper);
        }
        generator.writeKey("time_to_live_in_millis");
        generator.write(this.timeToLiveInMillis);
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.creationTime != null) {
            generator.writeKey("creation_time");
            this.creationTime.serialize(generator, mapper);
        }
        generator.writeKey("creation_time_in_millis");
        generator.write(this.creationTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSamplingConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rate, JsonpDeserializer.doubleDeserializer(), "rate");
        op.add(Builder::maxSamples, JsonpDeserializer.integerDeserializer(), "max_samples");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::maxSizeInBytes, JsonpDeserializer.longDeserializer(), "max_size_in_bytes");
        op.add(Builder::timeToLive, Time._DESERIALIZER, "time_to_live");
        op.add(Builder::timeToLiveInMillis, JsonpDeserializer.longDeserializer(), "time_to_live_in_millis");
        op.add(Builder::if_, JsonpDeserializer.stringDeserializer(), "if");
        op.add(Builder::creationTime, DateTime._DESERIALIZER, "creation_time");
        op.add(Builder::creationTimeInMillis, JsonpDeserializer.longDeserializer(), "creation_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SamplingConfiguration> {
        private Double rate;
        private Integer maxSamples;
        @Nullable
        private String maxSize;
        private Long maxSizeInBytes;
        @Nullable
        private Time timeToLive;
        private Long timeToLiveInMillis;
        @Nullable
        private String if_;
        @Nullable
        private DateTime creationTime;
        private Long creationTimeInMillis;

        public Builder() {
        }

        private Builder(SamplingConfiguration instance) {
            this.rate = instance.rate;
            this.maxSamples = instance.maxSamples;
            this.maxSize = instance.maxSize;
            this.maxSizeInBytes = instance.maxSizeInBytes;
            this.timeToLive = instance.timeToLive;
            this.timeToLiveInMillis = instance.timeToLiveInMillis;
            this.if_ = instance.if_;
            this.creationTime = instance.creationTime;
            this.creationTimeInMillis = instance.creationTimeInMillis;
        }

        public final Builder rate(double value) {
            this.rate = value;
            return this;
        }

        public final Builder maxSamples(int value) {
            this.maxSamples = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder maxSizeInBytes(long value) {
            this.maxSizeInBytes = value;
            return this;
        }

        public final Builder timeToLive(@Nullable Time value) {
            this.timeToLive = value;
            return this;
        }

        public final Builder timeToLive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeToLive(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeToLiveInMillis(long value) {
            this.timeToLiveInMillis = value;
            return this;
        }

        public final Builder if_(@Nullable String value) {
            this.if_ = value;
            return this;
        }

        public final Builder creationTime(@Nullable DateTime value) {
            this.creationTime = value;
            return this;
        }

        public final Builder creationTimeInMillis(long value) {
            this.creationTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamplingConfiguration build() {
            this._checkSingleUse();
            return new SamplingConfiguration(this);
        }
    }
}

