/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.PutSampleConfigurationResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutSampleConfigurationRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String if_;
    private final String index;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Integer maxSamples;
    @Nullable
    private final String maxSize;
    private final double rate;
    @Nullable
    private final Time timeToLive;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutSampleConfigurationRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutSampleConfigurationRequest::setupPutSampleConfigurationRequestDeserializer);
    public static final Endpoint<PutSampleConfigurationRequest, PutSampleConfigurationResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutSampleConfigurationRequest, PutSampleConfigurationResponse>("es/indices.put_sample_configuration", request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_sample");
            buf.append("/config");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutSampleConfigurationResponse._DESERIALIZER);

    private PutSampleConfigurationRequest(Builder builder) {
        this.if_ = builder.if_;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.masterTimeout = builder.masterTimeout;
        this.maxSamples = builder.maxSamples;
        this.maxSize = builder.maxSize;
        this.rate = ApiTypeHelper.requireNonNull(builder.rate, (Object)this, "rate", 0.0);
        this.timeToLive = builder.timeToLive;
        this.timeout = builder.timeout;
    }

    public static PutSampleConfigurationRequest of(Function<Builder, ObjectBuilder<PutSampleConfigurationRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String if_() {
        return this.if_;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Integer maxSamples() {
        return this.maxSamples;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    public final double rate() {
        return this.rate;
    }

    @Nullable
    public final Time timeToLive() {
        return this.timeToLive;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.if_ != null) {
            generator.writeKey("if");
            generator.write(this.if_);
        }
        if (this.maxSamples != null) {
            generator.writeKey("max_samples");
            generator.write(this.maxSamples.intValue());
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        generator.writeKey("rate");
        generator.write(this.rate);
        if (this.timeToLive != null) {
            generator.writeKey("time_to_live");
            this.timeToLive.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutSampleConfigurationRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::if_, JsonpDeserializer.stringDeserializer(), "if");
        op.add(Builder::maxSamples, JsonpDeserializer.integerDeserializer(), "max_samples");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::rate, JsonpDeserializer.doubleDeserializer(), "rate");
        op.add(Builder::timeToLive, Time._DESERIALIZER, "time_to_live");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutSampleConfigurationRequest> {
        @Nullable
        private String if_;
        private String index;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Integer maxSamples;
        @Nullable
        private String maxSize;
        private Double rate;
        @Nullable
        private Time timeToLive;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutSampleConfigurationRequest instance) {
            this.if_ = instance.if_;
            this.index = instance.index;
            this.masterTimeout = instance.masterTimeout;
            this.maxSamples = instance.maxSamples;
            this.maxSize = instance.maxSize;
            this.rate = instance.rate;
            this.timeToLive = instance.timeToLive;
            this.timeout = instance.timeout;
        }

        public final Builder if_(@Nullable String value) {
            this.if_ = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxSamples(@Nullable Integer value) {
            this.maxSamples = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder rate(double value) {
            this.rate = value;
            return this;
        }

        public final Builder timeToLive(@Nullable Time value) {
            this.timeToLive = value;
            return this;
        }

        public final Builder timeToLive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeToLive(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutSampleConfigurationRequest build() {
            this._checkSingleUse();
            return new PutSampleConfigurationRequest(this);
        }
    }
}

