/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexVersioning
implements JsonpSerializable {
    @Nullable
    private final String created;
    @Nullable
    private final String createdString;
    public static final JsonpDeserializer<IndexVersioning> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexVersioning::setupIndexVersioningDeserializer);

    private IndexVersioning(Builder builder) {
        this.created = builder.created;
        this.createdString = builder.createdString;
    }

    public static IndexVersioning of(Function<Builder, ObjectBuilder<IndexVersioning>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String created() {
        return this.created;
    }

    @Nullable
    public final String createdString() {
        return this.createdString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.created != null) {
            generator.writeKey("created");
            generator.write(this.created);
        }
        if (this.createdString != null) {
            generator.writeKey("created_string");
            generator.write(this.createdString);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndexVersioningDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::created, JsonpDeserializer.stringDeserializer(), "created");
        op.add(Builder::createdString, JsonpDeserializer.stringDeserializer(), "created_string");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexVersioning> {
        @Nullable
        private String created;
        @Nullable
        private String createdString;

        public Builder() {
        }

        private Builder(IndexVersioning instance) {
            this.created = instance.created;
            this.createdString = instance.createdString;
        }

        public final Builder created(@Nullable String value) {
            this.created = value;
            return this;
        }

        public final Builder createdString(@Nullable String value) {
            this.createdString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexVersioning build() {
            this._checkSingleUse();
            return new IndexVersioning(this);
        }
    }
}

