/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.DataStreamLifecycle;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexState
implements JsonpSerializable {
    private final Map<String, Alias> aliases;
    @Nullable
    private final TypeMapping mappings;
    @Nullable
    private final IndexSettings settings;
    @Nullable
    private final IndexSettings defaults;
    @Nullable
    private final String dataStream;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    public static final JsonpDeserializer<IndexState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexState::setupIndexStateDeserializer);

    private IndexState(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.settings = builder.settings;
        this.defaults = builder.defaults;
        this.dataStream = builder.dataStream;
        this.lifecycle = builder.lifecycle;
    }

    public static IndexState of(Function<Builder, ObjectBuilder<IndexState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Alias> aliases() {
        return this.aliases;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Nullable
    public final IndexSettings settings() {
        return this.settings;
    }

    @Nullable
    public final IndexSettings defaults() {
        return this.defaults;
    }

    @Nullable
    public final String dataStream() {
        return this.dataStream;
    }

    @Nullable
    public final DataStreamLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, Alias> item0 : this.aliases.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.defaults != null) {
            generator.writeKey("defaults");
            this.defaults.serialize(generator, mapper);
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            generator.write(this.dataStream);
        }
        if (this.lifecycle != null) {
            generator.writeKey("lifecycle");
            this.lifecycle.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndexStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(Alias._DESERIALIZER), "aliases");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings");
        op.add(Builder::defaults, IndexSettings._DESERIALIZER, "defaults");
        op.add(Builder::dataStream, JsonpDeserializer.stringDeserializer(), "data_stream");
        op.add(Builder::lifecycle, DataStreamLifecycle._DESERIALIZER, "lifecycle");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexState> {
        @Nullable
        private Map<String, Alias> aliases;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private IndexSettings settings;
        @Nullable
        private IndexSettings defaults;
        @Nullable
        private String dataStream;
        @Nullable
        private DataStreamLifecycle lifecycle;

        public Builder() {
        }

        private Builder(IndexState instance) {
            this.aliases = instance.aliases;
            this.mappings = instance.mappings;
            this.settings = instance.settings;
            this.defaults = instance.defaults;
            this.dataStream = instance.dataStream;
            this.lifecycle = instance.lifecycle;
        }

        public final Builder aliases(Map<String, Alias> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        public final Builder aliases(String key, Alias value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        public final Builder aliases(String key, Function<Alias.Builder, ObjectBuilder<Alias>> fn) {
            return this.aliases(key, fn.apply(new Alias.Builder()).build());
        }

        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        public final Builder settings(@Nullable IndexSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder defaults(@Nullable IndexSettings value) {
            this.defaults = value;
            return this;
        }

        public final Builder defaults(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.defaults(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder dataStream(@Nullable String value) {
            this.dataStream = value;
            return this;
        }

        public final Builder lifecycle(@Nullable DataStreamLifecycle value) {
            this.lifecycle = value;
            return this;
        }

        public final Builder lifecycle(Function<DataStreamLifecycle.Builder, ObjectBuilder<DataStreamLifecycle>> fn) {
            return this.lifecycle(fn.apply(new DataStreamLifecycle.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexState build() {
            this._checkSingleUse();
            return new IndexState(this);
        }
    }
}

