/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycleRolloverConditions
implements JsonpSerializable {
    @Nullable
    private final Time minAge;
    @Nullable
    private final String maxAge;
    @Nullable
    private final Long minDocs;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String minSize;
    @Nullable
    private final String maxSize;
    @Nullable
    private final String minPrimaryShardSize;
    @Nullable
    private final String maxPrimaryShardSize;
    @Nullable
    private final Long minPrimaryShardDocs;
    @Nullable
    private final Long maxPrimaryShardDocs;
    public static final JsonpDeserializer<DataStreamLifecycleRolloverConditions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycleRolloverConditions::setupDataStreamLifecycleRolloverConditionsDeserializer);

    private DataStreamLifecycleRolloverConditions(Builder builder) {
        this.minAge = builder.minAge;
        this.maxAge = builder.maxAge;
        this.minDocs = builder.minDocs;
        this.maxDocs = builder.maxDocs;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.minPrimaryShardSize = builder.minPrimaryShardSize;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
        this.minPrimaryShardDocs = builder.minPrimaryShardDocs;
        this.maxPrimaryShardDocs = builder.maxPrimaryShardDocs;
    }

    public static DataStreamLifecycleRolloverConditions of(Function<Builder, ObjectBuilder<DataStreamLifecycleRolloverConditions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time minAge() {
        return this.minAge;
    }

    @Nullable
    public final String maxAge() {
        return this.maxAge;
    }

    @Nullable
    public final Long minDocs() {
        return this.minDocs;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final String minSize() {
        return this.minSize;
    }

    @Nullable
    public final String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public final String minPrimaryShardSize() {
        return this.minPrimaryShardSize;
    }

    @Nullable
    public final String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Nullable
    public final Long minPrimaryShardDocs() {
        return this.minPrimaryShardDocs;
    }

    @Nullable
    public final Long maxPrimaryShardDocs() {
        return this.maxPrimaryShardDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.minAge != null) {
            generator.writeKey("min_age");
            this.minAge.serialize(generator, mapper);
        }
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            generator.write(this.maxAge);
        }
        if (this.minDocs != null) {
            generator.writeKey("min_docs");
            generator.write(this.minDocs.longValue());
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.minSize != null) {
            generator.writeKey("min_size");
            generator.write(this.minSize);
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.minPrimaryShardSize != null) {
            generator.writeKey("min_primary_shard_size");
            generator.write(this.minPrimaryShardSize);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
        if (this.minPrimaryShardDocs != null) {
            generator.writeKey("min_primary_shard_docs");
            generator.write(this.minPrimaryShardDocs.longValue());
        }
        if (this.maxPrimaryShardDocs != null) {
            generator.writeKey("max_primary_shard_docs");
            generator.write(this.maxPrimaryShardDocs.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamLifecycleRolloverConditionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::minAge, Time._DESERIALIZER, "min_age");
        op.add(Builder::maxAge, JsonpDeserializer.stringDeserializer(), "max_age");
        op.add(Builder::minDocs, JsonpDeserializer.longDeserializer(), "min_docs");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::minSize, JsonpDeserializer.stringDeserializer(), "min_size");
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size");
        op.add(Builder::minPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "min_primary_shard_size");
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size");
        op.add(Builder::minPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "min_primary_shard_docs");
        op.add(Builder::maxPrimaryShardDocs, JsonpDeserializer.longDeserializer(), "max_primary_shard_docs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamLifecycleRolloverConditions> {
        @Nullable
        private Time minAge;
        @Nullable
        private String maxAge;
        @Nullable
        private Long minDocs;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String minSize;
        @Nullable
        private String maxSize;
        @Nullable
        private String minPrimaryShardSize;
        @Nullable
        private String maxPrimaryShardSize;
        @Nullable
        private Long minPrimaryShardDocs;
        @Nullable
        private Long maxPrimaryShardDocs;

        public Builder() {
        }

        private Builder(DataStreamLifecycleRolloverConditions instance) {
            this.minAge = instance.minAge;
            this.maxAge = instance.maxAge;
            this.minDocs = instance.minDocs;
            this.maxDocs = instance.maxDocs;
            this.minSize = instance.minSize;
            this.maxSize = instance.maxSize;
            this.minPrimaryShardSize = instance.minPrimaryShardSize;
            this.maxPrimaryShardSize = instance.maxPrimaryShardSize;
            this.minPrimaryShardDocs = instance.minPrimaryShardDocs;
            this.maxPrimaryShardDocs = instance.maxPrimaryShardDocs;
        }

        public final Builder minAge(@Nullable Time value) {
            this.minAge = value;
            return this;
        }

        public final Builder minAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.minAge(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxAge(@Nullable String value) {
            this.maxAge = value;
            return this;
        }

        public final Builder minDocs(@Nullable Long value) {
            this.minDocs = value;
            return this;
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder minSize(@Nullable String value) {
            this.minSize = value;
            return this;
        }

        public final Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public final Builder minPrimaryShardSize(@Nullable String value) {
            this.minPrimaryShardSize = value;
            return this;
        }

        public final Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        public final Builder minPrimaryShardDocs(@Nullable Long value) {
            this.minPrimaryShardDocs = value;
            return this;
        }

        public final Builder maxPrimaryShardDocs(@Nullable Long value) {
            this.maxPrimaryShardDocs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycleRolloverConditions build() {
            this._checkSingleUse();
            return new DataStreamLifecycleRolloverConditions(this);
        }
    }
}

