/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.move_to_step;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StepKey
implements JsonpSerializable {
    @Nullable
    private final String action;
    @Nullable
    private final String name;
    private final String phase;
    public static final JsonpDeserializer<StepKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StepKey::setupStepKeyDeserializer);

    private StepKey(Builder builder) {
        this.action = builder.action;
        this.name = builder.name;
        this.phase = ApiTypeHelper.requireNonNull(builder.phase, this, "phase");
    }

    public static StepKey of(Function<Builder, ObjectBuilder<StepKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String action() {
        return this.action;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public final String phase() {
        return this.phase;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.action != null) {
            generator.writeKey("action");
            generator.write(this.action);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        generator.writeKey("phase");
        generator.write(this.phase);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupStepKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StepKey> {
        @Nullable
        private String action;
        @Nullable
        private String name;
        private String phase;

        public Builder() {
        }

        private Builder(StepKey instance) {
            this.action = instance.action;
            this.name = instance.name;
            this.phase = instance.phase;
        }

        public final Builder action(@Nullable String value) {
            this.action = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder phase(String value) {
            this.phase = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StepKey build() {
            this._checkSingleUse();
            return new StepKey(this);
        }
    }
}

