/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DownsampleAction
implements JsonpSerializable {
    private final Time fixedInterval;
    @Nullable
    private final Time waitTimeout;
    public static final JsonpDeserializer<DownsampleAction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DownsampleAction::setupDownsampleActionDeserializer);

    private DownsampleAction(Builder builder) {
        this.fixedInterval = ApiTypeHelper.requireNonNull(builder.fixedInterval, this, "fixedInterval");
        this.waitTimeout = builder.waitTimeout;
    }

    public static DownsampleAction of(Function<Builder, ObjectBuilder<DownsampleAction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final Time waitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fixed_interval");
        this.fixedInterval.serialize(generator, mapper);
        if (this.waitTimeout != null) {
            generator.writeKey("wait_timeout");
            this.waitTimeout.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDownsampleActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fixedInterval, Time._DESERIALIZER, "fixed_interval");
        op.add(Builder::waitTimeout, Time._DESERIALIZER, "wait_timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DownsampleAction> {
        private Time fixedInterval;
        @Nullable
        private Time waitTimeout;

        public Builder() {
        }

        private Builder(DownsampleAction instance) {
            this.fixedInterval = instance.fixedInterval;
            this.waitTimeout = instance.waitTimeout;
        }

        public final Builder fixedInterval(Time value) {
            this.fixedInterval = value;
            return this;
        }

        public final Builder fixedInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.fixedInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitTimeout(@Nullable Time value) {
            this.waitTimeout = value;
            return this;
        }

        public final Builder waitTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DownsampleAction build() {
            this._checkSingleUse();
            return new DownsampleAction(this);
        }
    }
}

