/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.esql;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlAdapter;
import co.elastic.clients.elasticsearch._helpers.esql.EsqlHelper;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.esql.DeleteViewRequest;
import co.elastic.clients.elasticsearch.esql.DeleteViewResponse;
import co.elastic.clients.elasticsearch.esql.GetQueryRequest;
import co.elastic.clients.elasticsearch.esql.GetQueryResponse;
import co.elastic.clients.elasticsearch.esql.GetViewRequest;
import co.elastic.clients.elasticsearch.esql.GetViewResponse;
import co.elastic.clients.elasticsearch.esql.ListQueriesRequest;
import co.elastic.clients.elasticsearch.esql.ListQueriesResponse;
import co.elastic.clients.elasticsearch.esql.PutViewRequest;
import co.elastic.clients.elasticsearch.esql.PutViewResponse;
import co.elastic.clients.elasticsearch.esql.QueryRequest;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchEsqlAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchEsqlAsyncClient> {
    public ElasticsearchEsqlAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchEsqlAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchEsqlAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchEsqlAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteViewResponse> deleteView(DeleteViewRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteViewRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteViewResponse> deleteView(Function<DeleteViewRequest.Builder, ObjectBuilder<DeleteViewRequest>> fn) {
        return this.deleteView(fn.apply(new DeleteViewRequest.Builder()).build());
    }

    public CompletableFuture<GetQueryResponse> getQuery(GetQueryRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetQueryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetQueryResponse> getQuery(Function<GetQueryRequest.Builder, ObjectBuilder<GetQueryRequest>> fn) {
        return this.getQuery(fn.apply(new GetQueryRequest.Builder()).build());
    }

    public CompletableFuture<GetViewResponse> getView(GetViewRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetViewRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetViewResponse> getView(Function<GetViewRequest.Builder, ObjectBuilder<GetViewRequest>> fn) {
        return this.getView(fn.apply(new GetViewRequest.Builder()).build());
    }

    public CompletableFuture<GetViewResponse> getView() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetViewRequest.Builder().build(), GetViewRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<ListQueriesResponse> listQueries() {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(ListQueriesRequest._INSTANCE, ListQueriesRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PutViewResponse> putView(PutViewRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)PutViewRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutViewResponse> putView(Function<PutViewRequest.Builder, ObjectBuilder<PutViewRequest>> fn) {
        return this.putView(fn.apply(new PutViewRequest.Builder()).build());
    }

    public CompletableFuture<BinaryResponse> query(QueryRequest request) {
        Endpoint<QueryRequest, BinaryResponse, ErrorResponse> endpoint = QueryRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<BinaryResponse> query(Function<QueryRequest.Builder, ObjectBuilder<QueryRequest>> fn) {
        return this.query(fn.apply(new QueryRequest.Builder()).build());
    }

    public final <T> CompletableFuture<T> query(EsqlAdapter<T> adapter, String query, Object ... parameters) {
        return EsqlHelper.queryAsync(this, adapter, query, parameters);
    }

    public final <T> CompletableFuture<T> query(EsqlAdapter<T> adapter, QueryRequest request) {
        return EsqlHelper.queryAsync(this, adapter, request);
    }

    public final <T> CompletableFuture<T> query(EsqlAdapter<T> adapter, Function<QueryRequest.Builder, ObjectBuilder<QueryRequest>> fn) {
        return EsqlHelper.queryAsync(this, adapter, fn.apply(new QueryRequest.Builder()).build());
    }
}

