/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnCollectorResult
implements JsonpSerializable {
    private final String name;
    private final String reason;
    @Nullable
    private final Time time;
    private final long timeInNanos;
    private final List<KnnCollectorResult> children;
    public static final JsonpDeserializer<KnnCollectorResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnCollectorResult::setupKnnCollectorResultDeserializer);

    private KnnCollectorResult(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.time = builder.time;
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, (Object)this, "timeInNanos", 0L);
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static KnnCollectorResult of(Function<Builder, ObjectBuilder<KnnCollectorResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final List<KnnCollectorResult> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("reason");
        generator.write(this.reason);
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (KnnCollectorResult item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupKnnCollectorResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::time, Time._DESERIALIZER, "time");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnCollectorResult> {
        private String name;
        private String reason;
        @Nullable
        private Time time;
        private Long timeInNanos;
        @Nullable
        private List<KnnCollectorResult> children;

        public Builder() {
        }

        private Builder(KnnCollectorResult instance) {
            this.name = instance.name;
            this.reason = instance.reason;
            this.time = instance.time;
            this.timeInNanos = instance.timeInNanos;
            this.children = instance.children;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder children(List<KnnCollectorResult> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(KnnCollectorResult value, KnnCollectorResult ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<KnnCollectorResult>> fn) {
            return this.children(fn.apply(new Builder()).build(), new KnnCollectorResult[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnCollectorResult build() {
            this._checkSingleUse();
            return new KnnCollectorResult(this);
        }
    }
}

