/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.KnnCollectorResult;
import co.elastic.clients.elasticsearch.core.search.KnnQueryProfileResult;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DfsKnnProfile
implements JsonpSerializable {
    @Nullable
    private final Long vectorOperationsCount;
    private final List<KnnQueryProfileResult> query;
    private final long rewriteTime;
    private final List<KnnCollectorResult> collector;
    public static final JsonpDeserializer<DfsKnnProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DfsKnnProfile::setupDfsKnnProfileDeserializer);

    private DfsKnnProfile(Builder builder) {
        this.vectorOperationsCount = builder.vectorOperationsCount;
        this.query = ApiTypeHelper.unmodifiableRequired(builder.query, (Object)this, "query");
        this.rewriteTime = ApiTypeHelper.requireNonNull(builder.rewriteTime, (Object)this, "rewriteTime", 0L);
        this.collector = ApiTypeHelper.unmodifiableRequired(builder.collector, (Object)this, "collector");
    }

    public static DfsKnnProfile of(Function<Builder, ObjectBuilder<DfsKnnProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long vectorOperationsCount() {
        return this.vectorOperationsCount;
    }

    public final List<KnnQueryProfileResult> query() {
        return this.query;
    }

    public final long rewriteTime() {
        return this.rewriteTime;
    }

    public final List<KnnCollectorResult> collector() {
        return this.collector;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.vectorOperationsCount != null) {
            generator.writeKey("vector_operations_count");
            generator.write(this.vectorOperationsCount.longValue());
        }
        if (ApiTypeHelper.isDefined(this.query)) {
            generator.writeKey("query");
            generator.writeStartArray();
            for (KnnQueryProfileResult knnQueryProfileResult : this.query) {
                knnQueryProfileResult.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("rewrite_time");
        generator.write(this.rewriteTime);
        if (ApiTypeHelper.isDefined(this.collector)) {
            generator.writeKey("collector");
            generator.writeStartArray();
            for (KnnCollectorResult knnCollectorResult : this.collector) {
                knnCollectorResult.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDfsKnnProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::vectorOperationsCount, JsonpDeserializer.longDeserializer(), "vector_operations_count");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(KnnQueryProfileResult._DESERIALIZER), "query");
        op.add(Builder::rewriteTime, JsonpDeserializer.longDeserializer(), "rewrite_time");
        op.add(Builder::collector, JsonpDeserializer.arrayDeserializer(KnnCollectorResult._DESERIALIZER), "collector");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DfsKnnProfile> {
        @Nullable
        private Long vectorOperationsCount;
        private List<KnnQueryProfileResult> query;
        private Long rewriteTime;
        private List<KnnCollectorResult> collector;

        public Builder() {
        }

        private Builder(DfsKnnProfile instance) {
            this.vectorOperationsCount = instance.vectorOperationsCount;
            this.query = instance.query;
            this.rewriteTime = instance.rewriteTime;
            this.collector = instance.collector;
        }

        public final Builder vectorOperationsCount(@Nullable Long value) {
            this.vectorOperationsCount = value;
            return this;
        }

        public final Builder query(List<KnnQueryProfileResult> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        public final Builder query(KnnQueryProfileResult value, KnnQueryProfileResult ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        public final Builder query(Function<KnnQueryProfileResult.Builder, ObjectBuilder<KnnQueryProfileResult>> fn) {
            return this.query(fn.apply(new KnnQueryProfileResult.Builder()).build(), new KnnQueryProfileResult[0]);
        }

        public final Builder rewriteTime(long value) {
            this.rewriteTime = value;
            return this;
        }

        public final Builder collector(List<KnnCollectorResult> list) {
            this.collector = Builder._listAddAll(this.collector, list);
            return this;
        }

        public final Builder collector(KnnCollectorResult value, KnnCollectorResult ... values) {
            this.collector = Builder._listAdd(this.collector, value, values);
            return this;
        }

        public final Builder collector(Function<KnnCollectorResult.Builder, ObjectBuilder<KnnCollectorResult>> fn) {
            return this.collector(fn.apply(new KnnCollectorResult.Builder()).build(), new KnnCollectorResult[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DfsKnnProfile build() {
            this._checkSingleUse();
            return new DfsKnnProfile(this);
        }
    }
}

