/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionSuggestOption;
import co.elastic.clients.elasticsearch.core.search.SuggestBase;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.elasticsearch.core.search.SuggestionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionSuggest<TDocument>
extends SuggestBase
implements SuggestionVariant {
    private final List<CompletionSuggestOption<TDocument>> options;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<CompletionSuggest<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> CompletionSuggest.createCompletionSuggestDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.search._types.CompletionSuggest.TDocument")));

    private CompletionSuggest(Builder<TDocument> builder) {
        super(builder);
        this.options = ApiTypeHelper.unmodifiableRequired(builder.options, (Object)this, "options");
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> CompletionSuggest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<CompletionSuggest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Suggestion.Kind _suggestionKind() {
        return Suggestion.Kind.Completion;
    }

    public final List<CompletionSuggestOption<TDocument>> options() {
        return this.options;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (CompletionSuggestOption<TDocument> item0 : this.options) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static <TDocument> JsonpDeserializer<CompletionSuggest<TDocument>> createCompletionSuggestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> CompletionSuggest.setupCompletionSuggestDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupCompletionSuggestDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        SuggestBase.setupSuggestBaseDeserializer(op);
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(CompletionSuggestOption.createCompletionSuggestOptionDeserializer(tDocumentDeserializer)), "options");
    }

    public static class Builder<TDocument>
    extends SuggestBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<CompletionSuggest<TDocument>> {
        private List<CompletionSuggestOption<TDocument>> options;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public Builder() {
        }

        private Builder(CompletionSuggest<TDocument> instance) {
            this.options = instance.options;
        }

        public final Builder<TDocument> options(List<CompletionSuggestOption<TDocument>> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        public final Builder<TDocument> options(CompletionSuggestOption<TDocument> value, CompletionSuggestOption<TDocument> ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        public final Builder<TDocument> options(Function<CompletionSuggestOption.Builder<TDocument>, ObjectBuilder<CompletionSuggestOption<TDocument>>> fn) {
            return this.options(fn.apply(new CompletionSuggestOption.Builder()).build(), new CompletionSuggestOption[0]);
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public CompletionSuggest<TDocument> build() {
            this._checkSingleUse();
            return new CompletionSuggest(this);
        }
    }
}

