/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RemoteSource
implements JsonpSerializable {
    @Nullable
    private final Time connectTimeout;
    private final Map<String, String> headers;
    private final String host;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String apiKey;
    @Nullable
    private final Time socketTimeout;
    public static final JsonpDeserializer<RemoteSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteSource::setupRemoteSourceDeserializer);

    private RemoteSource(Builder builder) {
        this.connectTimeout = builder.connectTimeout;
        this.headers = ApiTypeHelper.unmodifiable(builder.headers);
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.username = builder.username;
        this.password = builder.password;
        this.apiKey = builder.apiKey;
        this.socketTimeout = builder.socketTimeout;
    }

    public static RemoteSource of(Function<Builder, ObjectBuilder<RemoteSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time connectTimeout() {
        return this.connectTimeout;
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final String host() {
        return this.host;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final Time socketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.connectTimeout != null) {
            generator.writeKey("connect_timeout");
            this.connectTimeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("host");
        generator.write(this.host);
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.apiKey != null) {
            generator.writeKey("api_key");
            generator.write(this.apiKey);
        }
        if (this.socketTimeout != null) {
            generator.writeKey("socket_timeout");
            this.socketTimeout.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRemoteSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connectTimeout, Time._DESERIALIZER, "connect_timeout");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "headers");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::socketTimeout, Time._DESERIALIZER, "socket_timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoteSource> {
        @Nullable
        private Time connectTimeout;
        @Nullable
        private Map<String, String> headers;
        private String host;
        @Nullable
        private String username;
        @Nullable
        private String password;
        @Nullable
        private String apiKey;
        @Nullable
        private Time socketTimeout;

        public Builder() {
        }

        private Builder(RemoteSource instance) {
            this.connectTimeout = instance.connectTimeout;
            this.headers = instance.headers;
            this.host = instance.host;
            this.username = instance.username;
            this.password = instance.password;
            this.apiKey = instance.apiKey;
            this.socketTimeout = instance.socketTimeout;
        }

        public final Builder connectTimeout(@Nullable Time value) {
            this.connectTimeout = value;
            return this;
        }

        public final Builder connectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.connectTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder headers(Map<String, String> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, String value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder apiKey(@Nullable String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder socketTimeout(@Nullable Time value) {
            this.socketTimeout = value;
            return this;
        }

        public final Builder socketTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.socketTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoteSource build() {
            this._checkSingleUse();
            return new RemoteSource(this);
        }
    }
}

