/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.mtermvectors;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch.core.termvectors.Filter;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiTermVectorsOperation
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final JsonData doc;
    private final List<String> fields;
    @Nullable
    private final Boolean fieldStatistics;
    @Nullable
    private final Filter filter;
    @Nullable
    private final Boolean offsets;
    @Nullable
    private final Boolean payloads;
    @Nullable
    private final Boolean positions;
    private final List<String> routing;
    @Nullable
    private final Boolean termStatistics;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MultiTermVectorsOperation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermVectorsOperation::setupMultiTermVectorsOperationDeserializer);

    private MultiTermVectorsOperation(Builder builder) {
        this.id = builder.id;
        this.index = builder.index;
        this.doc = builder.doc;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.fieldStatistics = builder.fieldStatistics;
        this.filter = builder.filter;
        this.offsets = builder.offsets;
        this.payloads = builder.payloads;
        this.positions = builder.positions;
        this.routing = ApiTypeHelper.unmodifiable(builder.routing);
        this.termStatistics = builder.termStatistics;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MultiTermVectorsOperation of(Function<Builder, ObjectBuilder<MultiTermVectorsOperation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final JsonData doc() {
        return this.doc;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean fieldStatistics() {
        return this.fieldStatistics;
    }

    @Nullable
    public final Filter filter() {
        return this.filter;
    }

    @Nullable
    public final Boolean offsets() {
        return this.offsets;
    }

    @Nullable
    public final Boolean payloads() {
        return this.payloads;
    }

    @Nullable
    public final Boolean positions() {
        return this.positions;
    }

    public final List<String> routing() {
        return this.routing;
    }

    @Nullable
    public final Boolean termStatistics() {
        return this.termStatistics;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.fieldStatistics != null) {
            generator.writeKey("field_statistics");
            generator.write(this.fieldStatistics.booleanValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.offsets != null) {
            generator.writeKey("offsets");
            generator.write(this.offsets.booleanValue());
        }
        if (this.payloads != null) {
            generator.writeKey("payloads");
            generator.write(this.payloads.booleanValue());
        }
        if (this.positions != null) {
            generator.writeKey("positions");
            generator.write(this.positions.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.routing)) {
            generator.writeKey("routing");
            generator.writeStartArray();
            for (String item0 : this.routing) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.termStatistics != null) {
            generator.writeKey("term_statistics");
            generator.write(this.termStatistics.booleanValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMultiTermVectorsOperationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::doc, JsonData._DESERIALIZER, "doc");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::fieldStatistics, JsonpDeserializer.booleanDeserializer(), "field_statistics");
        op.add(Builder::filter, Filter._DESERIALIZER, "filter");
        op.add(Builder::offsets, JsonpDeserializer.booleanDeserializer(), "offsets");
        op.add(Builder::payloads, JsonpDeserializer.booleanDeserializer(), "payloads");
        op.add(Builder::positions, JsonpDeserializer.booleanDeserializer(), "positions");
        op.add(Builder::routing, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "routing");
        op.add(Builder::termStatistics, JsonpDeserializer.booleanDeserializer(), "term_statistics");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MultiTermVectorsOperation> {
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private JsonData doc;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean fieldStatistics;
        @Nullable
        private Filter filter;
        @Nullable
        private Boolean offsets;
        @Nullable
        private Boolean payloads;
        @Nullable
        private Boolean positions;
        @Nullable
        private List<String> routing;
        @Nullable
        private Boolean termStatistics;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(MultiTermVectorsOperation instance) {
            this.id = instance.id;
            this.index = instance.index;
            this.doc = instance.doc;
            this.fields = instance.fields;
            this.fieldStatistics = instance.fieldStatistics;
            this.filter = instance.filter;
            this.offsets = instance.offsets;
            this.payloads = instance.payloads;
            this.positions = instance.positions;
            this.routing = instance.routing;
            this.termStatistics = instance.termStatistics;
            this.version = instance.version;
            this.versionType = instance.versionType;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder doc(@Nullable JsonData value) {
            this.doc = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fieldStatistics(@Nullable Boolean value) {
            this.fieldStatistics = value;
            return this;
        }

        public final Builder filter(@Nullable Filter value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Filter.Builder, ObjectBuilder<Filter>> fn) {
            return this.filter(fn.apply(new Filter.Builder()).build());
        }

        public final Builder offsets(@Nullable Boolean value) {
            this.offsets = value;
            return this;
        }

        public final Builder payloads(@Nullable Boolean value) {
            this.payloads = value;
            return this;
        }

        public final Builder positions(@Nullable Boolean value) {
            this.positions = value;
            return this;
        }

        public final Builder routing(List<String> list) {
            this.routing = Builder._listAddAll(this.routing, list);
            return this;
        }

        public final Builder routing(String value, String ... values) {
            this.routing = Builder._listAdd(this.routing, value, values);
            return this;
        }

        public final Builder termStatistics(@Nullable Boolean value) {
            this.termStatistics = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermVectorsOperation build() {
            this._checkSingleUse();
            return new MultiTermVectorsOperation(this);
        }
    }
}

