/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchHeader;
import co.elastic.clients.elasticsearch.core.search.SearchRequestBody;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;

public class RequestItem
implements NdJsonpSerializable,
JsonpSerializable {
    private final MultisearchHeader header;
    private final SearchRequestBody body;

    private RequestItem(Builder builder) {
        this.header = ApiTypeHelper.requireNonNull(builder.header, this, "header");
        this.body = ApiTypeHelper.requireNonNull(builder.body, this, "body");
    }

    public static RequestItem of(Function<Builder, ObjectBuilder<RequestItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Iterator<?> _serializables() {
        return Arrays.asList(this.header, this.body).iterator();
    }

    public final MultisearchHeader header() {
        return this.header;
    }

    public final SearchRequestBody body() {
        return this.body;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("header");
        this.header.serialize(generator, mapper);
        generator.writeKey("body");
        this.body.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RequestItem> {
        private MultisearchHeader header;
        private SearchRequestBody body;

        public Builder() {
        }

        private Builder(RequestItem instance) {
            this.header = instance.header;
            this.body = instance.body;
        }

        public final Builder header(MultisearchHeader value) {
            this.header = value;
            return this;
        }

        public final Builder header(Function<MultisearchHeader.Builder, ObjectBuilder<MultisearchHeader>> fn) {
            return this.header(fn.apply(new MultisearchHeader.Builder()).build());
        }

        public final Builder body(SearchRequestBody value) {
            this.body = value;
            return this;
        }

        public final Builder body(Function<SearchRequestBody.Builder, ObjectBuilder<SearchRequestBody>> fn) {
            return this.body(fn.apply(new SearchRequestBody.Builder()).build());
        }

        public final Builder body(SearchRequest value) {
            SearchRequestBody body;
            this.body = body = SearchRequestBody.of(srb -> srb.aggregations(value.aggregations()).collapse(value.collapse()).explain(value.explain()).ext(value.ext()).from(value.from()).highlight(value.highlight()).trackTotalHits(value.trackTotalHits()).indicesBoost(value.indicesBoost()).docvalueFields(value.docvalueFields()).knn(value.knn()).rank(value.rank()).minScore(value.minScore()).postFilter(value.postFilter()).profile(value.profile()).query(value.query()).rescore(value.rescore()).retriever(value.retriever()).scriptFields(value.scriptFields()).searchAfter(value.searchAfter()).size(value.size()).slice(value.slice()).sort(value.sort()).source(value.source()).fields(value.fields()).suggest(value.suggest()).terminateAfter(value.terminateAfter()).timeout(value.timeout()).trackScores(value.trackScores()).version(value.version()).seqNoPrimaryTerm(value.seqNoPrimaryTerm()).storedFields(value.storedFields()).pit(value.pit()).runtimeMappings(value.runtimeMappings()).stats(value.stats()));
            return this;
        }

        @Override
        public RequestItem build() {
            this._checkSingleUse();
            return new RequestItem(this);
        }
    }
}

