/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ScriptSource;
import co.elastic.clients.elasticsearch.core.RenderSearchTemplateResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RenderSearchTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String file;
    @Nullable
    private final String id;
    private final Map<String, JsonData> params;
    @Nullable
    private final ScriptSource source;
    public static final JsonpDeserializer<RenderSearchTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RenderSearchTemplateRequest::setupRenderSearchTemplateRequestDeserializer);
    public static final Endpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse>("es/render_search_template", request -> "POST", request -> "/_render/template", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RenderSearchTemplateResponse._DESERIALIZER);

    private RenderSearchTemplateRequest(Builder builder) {
        this.file = builder.file;
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
    }

    public static RenderSearchTemplateRequest of(Function<Builder, ObjectBuilder<RenderSearchTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String file() {
        return this.file;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final ScriptSource source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.file != null) {
            generator.writeKey("file");
            generator.write(this.file);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRenderSearchTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::file, JsonpDeserializer.stringDeserializer(), "file");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, ScriptSource._DESERIALIZER, "source");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RenderSearchTemplateRequest> {
        @Nullable
        private String file;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private ScriptSource source;

        public Builder() {
        }

        private Builder(RenderSearchTemplateRequest instance) {
            this.file = instance.file;
            this.id = instance.id;
            this.params = instance.params;
            this.source = instance.source;
        }

        public final Builder file(@Nullable String value) {
            this.file = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder source(@Nullable ScriptSource value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<ScriptSource.Builder, ObjectBuilder<ScriptSource>> fn) {
            return this.source(fn.apply(new ScriptSource.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RenderSearchTemplateRequest build() {
            this._checkSingleUse();
            return new RenderSearchTemplateRequest(this);
        }
    }
}

