/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.SyncJobListResponse;
import co.elastic.clients.elasticsearch.connector.SyncJobType;
import co.elastic.clients.elasticsearch.connector.SyncStatus;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SyncJobListRequest
extends RequestBase {
    @Nullable
    private final String connectorId;
    @Nullable
    private final Integer from;
    private final List<SyncJobType> jobType;
    @Nullable
    private final Integer size;
    @Nullable
    private final SyncStatus status;
    public static final Endpoint<SyncJobListRequest, SyncJobListResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SyncJobListRequest, SyncJobListResponse>("es/connector.sync_job_list", request -> "GET", request -> "/_connector/_sync_job", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.jobType)) {
            params.put("job_type", request.jobType.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.connectorId != null) {
            params.put("connector_id", request.connectorId);
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.status != null) {
            params.put("status", request.status.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SyncJobListResponse._DESERIALIZER);

    private SyncJobListRequest(Builder builder) {
        this.connectorId = builder.connectorId;
        this.from = builder.from;
        this.jobType = ApiTypeHelper.unmodifiable(builder.jobType);
        this.size = builder.size;
        this.status = builder.status;
    }

    public static SyncJobListRequest of(Function<Builder, ObjectBuilder<SyncJobListRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String connectorId() {
        return this.connectorId;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final List<SyncJobType> jobType() {
        return this.jobType;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final SyncStatus status() {
        return this.status;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SyncJobListRequest> {
        @Nullable
        private String connectorId;
        @Nullable
        private Integer from;
        @Nullable
        private List<SyncJobType> jobType;
        @Nullable
        private Integer size;
        @Nullable
        private SyncStatus status;

        public Builder() {
        }

        private Builder(SyncJobListRequest instance) {
            this.connectorId = instance.connectorId;
            this.from = instance.from;
            this.jobType = instance.jobType;
            this.size = instance.size;
            this.status = instance.status;
        }

        public final Builder connectorId(@Nullable String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobType(List<SyncJobType> list) {
            this.jobType = Builder._listAddAll(this.jobType, list);
            return this;
        }

        public final Builder jobType(SyncJobType value, SyncJobType ... values) {
            this.jobType = Builder._listAdd(this.jobType, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder status(@Nullable SyncStatus value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobListRequest build() {
            this._checkSingleUse();
            return new SyncJobListRequest(this);
        }
    }
}

