/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.ListResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class ListRequest
extends RequestBase {
    private final List<String> connectorName;
    @Nullable
    private final Integer from;
    @Nullable
    private final Boolean includeDeleted;
    private final List<String> indexName;
    @Nullable
    private final String query;
    private final List<String> serviceType;
    @Nullable
    private final Integer size;
    public static final Endpoint<ListRequest, ListResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ListRequest, ListResponse>("es/connector.list", request -> "GET", request -> "/_connector", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.serviceType)) {
            params.put("service_type", request.serviceType.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.query != null) {
            params.put("query", request.query);
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.includeDeleted != null) {
            params.put("include_deleted", String.valueOf(request.includeDeleted));
        }
        if (ApiTypeHelper.isDefined(request.connectorName)) {
            params.put("connector_name", request.connectorName.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.indexName)) {
            params.put("index_name", request.indexName.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ListResponse._DESERIALIZER);

    private ListRequest(Builder builder) {
        this.connectorName = ApiTypeHelper.unmodifiable(builder.connectorName);
        this.from = builder.from;
        this.includeDeleted = builder.includeDeleted;
        this.indexName = ApiTypeHelper.unmodifiable(builder.indexName);
        this.query = builder.query;
        this.serviceType = ApiTypeHelper.unmodifiable(builder.serviceType);
        this.size = builder.size;
    }

    public static ListRequest of(Function<Builder, ObjectBuilder<ListRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> connectorName() {
        return this.connectorName;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Boolean includeDeleted() {
        return this.includeDeleted;
    }

    public final List<String> indexName() {
        return this.indexName;
    }

    @Nullable
    public final String query() {
        return this.query;
    }

    public final List<String> serviceType() {
        return this.serviceType;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ListRequest> {
        @Nullable
        private List<String> connectorName;
        @Nullable
        private Integer from;
        @Nullable
        private Boolean includeDeleted;
        @Nullable
        private List<String> indexName;
        @Nullable
        private String query;
        @Nullable
        private List<String> serviceType;
        @Nullable
        private Integer size;

        public Builder() {
        }

        private Builder(ListRequest instance) {
            this.connectorName = instance.connectorName;
            this.from = instance.from;
            this.includeDeleted = instance.includeDeleted;
            this.indexName = instance.indexName;
            this.query = instance.query;
            this.serviceType = instance.serviceType;
            this.size = instance.size;
        }

        public final Builder connectorName(List<String> list) {
            this.connectorName = Builder._listAddAll(this.connectorName, list);
            return this;
        }

        public final Builder connectorName(String value, String ... values) {
            this.connectorName = Builder._listAdd(this.connectorName, value, values);
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder includeDeleted(@Nullable Boolean value) {
            this.includeDeleted = value;
            return this;
        }

        public final Builder indexName(List<String> list) {
            this.indexName = Builder._listAddAll(this.indexName, list);
            return this;
        }

        public final Builder indexName(String value, String ... values) {
            this.indexName = Builder._listAdd(this.indexName, value, values);
            return this;
        }

        public final Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public final Builder serviceType(List<String> list) {
            this.serviceType = Builder._listAddAll(this.serviceType, list);
            return this;
        }

        public final Builder serviceType(String value, String ... values) {
            this.serviceType = Builder._listAdd(this.serviceType, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListRequest build() {
            this._checkSingleUse();
            return new ListRequest(this);
        }
    }
}

