/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch.connector.FilteringAdvancedSnippet;
import co.elastic.clients.elasticsearch.connector.FilteringRule;
import co.elastic.clients.elasticsearch.connector.FilteringRulesValidation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FilteringRules
implements JsonpSerializable {
    private final FilteringAdvancedSnippet advancedSnippet;
    private final List<FilteringRule> rules;
    private final FilteringRulesValidation validation;
    public static final JsonpDeserializer<FilteringRules> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringRules::setupFilteringRulesDeserializer);

    private FilteringRules(Builder builder) {
        this.advancedSnippet = ApiTypeHelper.requireNonNull(builder.advancedSnippet, this, "advancedSnippet");
        this.rules = ApiTypeHelper.unmodifiableRequired(builder.rules, (Object)this, "rules");
        this.validation = ApiTypeHelper.requireNonNull(builder.validation, this, "validation");
    }

    public static FilteringRules of(Function<Builder, ObjectBuilder<FilteringRules>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final FilteringAdvancedSnippet advancedSnippet() {
        return this.advancedSnippet;
    }

    public final List<FilteringRule> rules() {
        return this.rules;
    }

    public final FilteringRulesValidation validation() {
        return this.validation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("advanced_snippet");
        this.advancedSnippet.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (FilteringRule item0 : this.rules) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("validation");
        this.validation.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFilteringRulesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::advancedSnippet, FilteringAdvancedSnippet._DESERIALIZER, "advanced_snippet");
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(FilteringRule._DESERIALIZER), "rules");
        op.add(Builder::validation, FilteringRulesValidation._DESERIALIZER, "validation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringRules> {
        private FilteringAdvancedSnippet advancedSnippet;
        private List<FilteringRule> rules;
        private FilteringRulesValidation validation;

        public Builder() {
        }

        private Builder(FilteringRules instance) {
            this.advancedSnippet = instance.advancedSnippet;
            this.rules = instance.rules;
            this.validation = instance.validation;
        }

        public final Builder advancedSnippet(FilteringAdvancedSnippet value) {
            this.advancedSnippet = value;
            return this;
        }

        public final Builder advancedSnippet(Function<FilteringAdvancedSnippet.Builder, ObjectBuilder<FilteringAdvancedSnippet>> fn) {
            return this.advancedSnippet(fn.apply(new FilteringAdvancedSnippet.Builder()).build());
        }

        public final Builder rules(List<FilteringRule> list) {
            this.rules = Builder._listAddAll(this.rules, list);
            return this;
        }

        public final Builder rules(FilteringRule value, FilteringRule ... values) {
            this.rules = Builder._listAdd(this.rules, value, values);
            return this;
        }

        public final Builder rules(Function<FilteringRule.Builder, ObjectBuilder<FilteringRule>> fn) {
            return this.rules(fn.apply(new FilteringRule.Builder()).build(), new FilteringRule[0]);
        }

        public final Builder validation(FilteringRulesValidation value) {
            this.validation = value;
            return this;
        }

        public final Builder validation(Function<FilteringRulesValidation.Builder, ObjectBuilder<FilteringRulesValidation>> fn) {
            return this.validation(fn.apply(new FilteringRulesValidation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringRules build() {
            this._checkSingleUse();
            return new FilteringRules(this);
        }
    }
}

