/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RuntimeFieldTypes
implements JsonpSerializable {
    private final int charsMax;
    private final int charsTotal;
    private final int count;
    private final int docMax;
    private final int docTotal;
    private final int indexCount;
    private final List<String> lang;
    private final int linesMax;
    private final int linesTotal;
    private final String name;
    private final int scriptlessCount;
    private final int shadowedCount;
    private final int sourceMax;
    private final int sourceTotal;
    public static final JsonpDeserializer<RuntimeFieldTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldTypes::setupRuntimeFieldTypesDeserializer);

    private RuntimeFieldTypes(Builder builder) {
        this.charsMax = ApiTypeHelper.requireNonNull(builder.charsMax, (Object)this, "charsMax", 0);
        this.charsTotal = ApiTypeHelper.requireNonNull(builder.charsTotal, (Object)this, "charsTotal", 0);
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.docMax = ApiTypeHelper.requireNonNull(builder.docMax, (Object)this, "docMax", 0);
        this.docTotal = ApiTypeHelper.requireNonNull(builder.docTotal, (Object)this, "docTotal", 0);
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0);
        this.lang = ApiTypeHelper.unmodifiableRequired(builder.lang, (Object)this, "lang");
        this.linesMax = ApiTypeHelper.requireNonNull(builder.linesMax, (Object)this, "linesMax", 0);
        this.linesTotal = ApiTypeHelper.requireNonNull(builder.linesTotal, (Object)this, "linesTotal", 0);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.scriptlessCount = ApiTypeHelper.requireNonNull(builder.scriptlessCount, (Object)this, "scriptlessCount", 0);
        this.shadowedCount = ApiTypeHelper.requireNonNull(builder.shadowedCount, (Object)this, "shadowedCount", 0);
        this.sourceMax = ApiTypeHelper.requireNonNull(builder.sourceMax, (Object)this, "sourceMax", 0);
        this.sourceTotal = ApiTypeHelper.requireNonNull(builder.sourceTotal, (Object)this, "sourceTotal", 0);
    }

    public static RuntimeFieldTypes of(Function<Builder, ObjectBuilder<RuntimeFieldTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int charsMax() {
        return this.charsMax;
    }

    public final int charsTotal() {
        return this.charsTotal;
    }

    public final int count() {
        return this.count;
    }

    public final int docMax() {
        return this.docMax;
    }

    public final int docTotal() {
        return this.docTotal;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    public final List<String> lang() {
        return this.lang;
    }

    public final int linesMax() {
        return this.linesMax;
    }

    public final int linesTotal() {
        return this.linesTotal;
    }

    public final String name() {
        return this.name;
    }

    public final int scriptlessCount() {
        return this.scriptlessCount;
    }

    public final int shadowedCount() {
        return this.shadowedCount;
    }

    public final int sourceMax() {
        return this.sourceMax;
    }

    public final int sourceTotal() {
        return this.sourceTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("chars_max");
        generator.write(this.charsMax);
        generator.writeKey("chars_total");
        generator.write(this.charsTotal);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("doc_max");
        generator.write(this.docMax);
        generator.writeKey("doc_total");
        generator.write(this.docTotal);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (ApiTypeHelper.isDefined(this.lang)) {
            generator.writeKey("lang");
            generator.writeStartArray();
            for (String item0 : this.lang) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("lines_max");
        generator.write(this.linesMax);
        generator.writeKey("lines_total");
        generator.write(this.linesTotal);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("scriptless_count");
        generator.write(this.scriptlessCount);
        generator.writeKey("shadowed_count");
        generator.write(this.shadowedCount);
        generator.writeKey("source_max");
        generator.write(this.sourceMax);
        generator.writeKey("source_total");
        generator.write(this.sourceTotal);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRuntimeFieldTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charsMax, JsonpDeserializer.integerDeserializer(), "chars_max");
        op.add(Builder::charsTotal, JsonpDeserializer.integerDeserializer(), "chars_total");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::docMax, JsonpDeserializer.integerDeserializer(), "doc_max");
        op.add(Builder::docTotal, JsonpDeserializer.integerDeserializer(), "doc_total");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::lang, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "lang");
        op.add(Builder::linesMax, JsonpDeserializer.integerDeserializer(), "lines_max");
        op.add(Builder::linesTotal, JsonpDeserializer.integerDeserializer(), "lines_total");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::scriptlessCount, JsonpDeserializer.integerDeserializer(), "scriptless_count");
        op.add(Builder::shadowedCount, JsonpDeserializer.integerDeserializer(), "shadowed_count");
        op.add(Builder::sourceMax, JsonpDeserializer.integerDeserializer(), "source_max");
        op.add(Builder::sourceTotal, JsonpDeserializer.integerDeserializer(), "source_total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RuntimeFieldTypes> {
        private Integer charsMax;
        private Integer charsTotal;
        private Integer count;
        private Integer docMax;
        private Integer docTotal;
        private Integer indexCount;
        private List<String> lang;
        private Integer linesMax;
        private Integer linesTotal;
        private String name;
        private Integer scriptlessCount;
        private Integer shadowedCount;
        private Integer sourceMax;
        private Integer sourceTotal;

        public Builder() {
        }

        private Builder(RuntimeFieldTypes instance) {
            this.charsMax = instance.charsMax;
            this.charsTotal = instance.charsTotal;
            this.count = instance.count;
            this.docMax = instance.docMax;
            this.docTotal = instance.docTotal;
            this.indexCount = instance.indexCount;
            this.lang = instance.lang;
            this.linesMax = instance.linesMax;
            this.linesTotal = instance.linesTotal;
            this.name = instance.name;
            this.scriptlessCount = instance.scriptlessCount;
            this.shadowedCount = instance.shadowedCount;
            this.sourceMax = instance.sourceMax;
            this.sourceTotal = instance.sourceTotal;
        }

        public final Builder charsMax(int value) {
            this.charsMax = value;
            return this;
        }

        public final Builder charsTotal(int value) {
            this.charsTotal = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder docMax(int value) {
            this.docMax = value;
            return this;
        }

        public final Builder docTotal(int value) {
            this.docTotal = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder lang(List<String> list) {
            this.lang = Builder._listAddAll(this.lang, list);
            return this;
        }

        public final Builder lang(String value, String ... values) {
            this.lang = Builder._listAdd(this.lang, value, values);
            return this;
        }

        public final Builder linesMax(int value) {
            this.linesMax = value;
            return this;
        }

        public final Builder linesTotal(int value) {
            this.linesTotal = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder scriptlessCount(int value) {
            this.scriptlessCount = value;
            return this;
        }

        public final Builder shadowedCount(int value) {
            this.shadowedCount = value;
            return this;
        }

        public final Builder sourceMax(int value) {
            this.sourceMax = value;
            return this;
        }

        public final Builder sourceTotal(int value) {
            this.sourceTotal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeFieldTypes build() {
            this._checkSingleUse();
            return new RuntimeFieldTypes(this);
        }
    }
}

