/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.RepositoryStatsShards;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RepositoryStatsCurrentCounts
implements JsonpSerializable {
    private final int snapshots;
    private final int clones;
    private final int finalizations;
    private final int deletions;
    private final int snapshotDeletions;
    private final int activeDeletions;
    private final RepositoryStatsShards shards;
    public static final JsonpDeserializer<RepositoryStatsCurrentCounts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryStatsCurrentCounts::setupRepositoryStatsCurrentCountsDeserializer);

    private RepositoryStatsCurrentCounts(Builder builder) {
        this.snapshots = ApiTypeHelper.requireNonNull(builder.snapshots, (Object)this, "snapshots", 0);
        this.clones = ApiTypeHelper.requireNonNull(builder.clones, (Object)this, "clones", 0);
        this.finalizations = ApiTypeHelper.requireNonNull(builder.finalizations, (Object)this, "finalizations", 0);
        this.deletions = ApiTypeHelper.requireNonNull(builder.deletions, (Object)this, "deletions", 0);
        this.snapshotDeletions = ApiTypeHelper.requireNonNull(builder.snapshotDeletions, (Object)this, "snapshotDeletions", 0);
        this.activeDeletions = ApiTypeHelper.requireNonNull(builder.activeDeletions, (Object)this, "activeDeletions", 0);
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static RepositoryStatsCurrentCounts of(Function<Builder, ObjectBuilder<RepositoryStatsCurrentCounts>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int snapshots() {
        return this.snapshots;
    }

    public final int clones() {
        return this.clones;
    }

    public final int finalizations() {
        return this.finalizations;
    }

    public final int deletions() {
        return this.deletions;
    }

    public final int snapshotDeletions() {
        return this.snapshotDeletions;
    }

    public final int activeDeletions() {
        return this.activeDeletions;
    }

    public final RepositoryStatsShards shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshots");
        generator.write(this.snapshots);
        generator.writeKey("clones");
        generator.write(this.clones);
        generator.writeKey("finalizations");
        generator.write(this.finalizations);
        generator.writeKey("deletions");
        generator.write(this.deletions);
        generator.writeKey("snapshot_deletions");
        generator.write(this.snapshotDeletions);
        generator.writeKey("active_deletions");
        generator.write(this.activeDeletions);
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRepositoryStatsCurrentCountsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.integerDeserializer(), "snapshots");
        op.add(Builder::clones, JsonpDeserializer.integerDeserializer(), "clones");
        op.add(Builder::finalizations, JsonpDeserializer.integerDeserializer(), "finalizations");
        op.add(Builder::deletions, JsonpDeserializer.integerDeserializer(), "deletions");
        op.add(Builder::snapshotDeletions, JsonpDeserializer.integerDeserializer(), "snapshot_deletions");
        op.add(Builder::activeDeletions, JsonpDeserializer.integerDeserializer(), "active_deletions");
        op.add(Builder::shards, RepositoryStatsShards._DESERIALIZER, "shards");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoryStatsCurrentCounts> {
        private Integer snapshots;
        private Integer clones;
        private Integer finalizations;
        private Integer deletions;
        private Integer snapshotDeletions;
        private Integer activeDeletions;
        private RepositoryStatsShards shards;

        public Builder() {
        }

        private Builder(RepositoryStatsCurrentCounts instance) {
            this.snapshots = instance.snapshots;
            this.clones = instance.clones;
            this.finalizations = instance.finalizations;
            this.deletions = instance.deletions;
            this.snapshotDeletions = instance.snapshotDeletions;
            this.activeDeletions = instance.activeDeletions;
            this.shards = instance.shards;
        }

        public final Builder snapshots(int value) {
            this.snapshots = value;
            return this;
        }

        public final Builder clones(int value) {
            this.clones = value;
            return this;
        }

        public final Builder finalizations(int value) {
            this.finalizations = value;
            return this;
        }

        public final Builder deletions(int value) {
            this.deletions = value;
            return this;
        }

        public final Builder snapshotDeletions(int value) {
            this.snapshotDeletions = value;
            return this;
        }

        public final Builder activeDeletions(int value) {
            this.activeDeletions = value;
            return this;
        }

        public final Builder shards(RepositoryStatsShards value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<RepositoryStatsShards.Builder, ObjectBuilder<RepositoryStatsShards>> fn) {
            return this.shards(fn.apply(new RepositoryStatsShards.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryStatsCurrentCounts build() {
            this._checkSingleUse();
            return new RepositoryStatsCurrentCounts(this);
        }
    }
}

