/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesVersions
implements JsonpSerializable {
    private final int indexCount;
    private final int primaryShardCount;
    private final long totalPrimaryBytes;
    @Nullable
    private final String totalPrimarySize;
    private final String version;
    public static final JsonpDeserializer<IndicesVersions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesVersions::setupIndicesVersionsDeserializer);

    private IndicesVersions(Builder builder) {
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0);
        this.primaryShardCount = ApiTypeHelper.requireNonNull(builder.primaryShardCount, (Object)this, "primaryShardCount", 0);
        this.totalPrimaryBytes = ApiTypeHelper.requireNonNull(builder.totalPrimaryBytes, (Object)this, "totalPrimaryBytes", 0L);
        this.totalPrimarySize = builder.totalPrimarySize;
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static IndicesVersions of(Function<Builder, ObjectBuilder<IndicesVersions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int indexCount() {
        return this.indexCount;
    }

    public final int primaryShardCount() {
        return this.primaryShardCount;
    }

    public final long totalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    @Nullable
    public final String totalPrimarySize() {
        return this.totalPrimarySize;
    }

    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("total_primary_bytes");
        generator.write(this.totalPrimaryBytes);
        if (this.totalPrimarySize != null) {
            generator.writeKey("total_primary_size");
            generator.write(this.totalPrimarySize);
        }
        generator.writeKey("version");
        generator.write(this.version);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndicesVersionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
        op.add(Builder::primaryShardCount, JsonpDeserializer.integerDeserializer(), "primary_shard_count");
        op.add(Builder::totalPrimaryBytes, JsonpDeserializer.longDeserializer(), "total_primary_bytes");
        op.add(Builder::totalPrimarySize, JsonpDeserializer.stringDeserializer(), "total_primary_size");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicesVersions> {
        private Integer indexCount;
        private Integer primaryShardCount;
        private Long totalPrimaryBytes;
        @Nullable
        private String totalPrimarySize;
        private String version;

        public Builder() {
        }

        private Builder(IndicesVersions instance) {
            this.indexCount = instance.indexCount;
            this.primaryShardCount = instance.primaryShardCount;
            this.totalPrimaryBytes = instance.totalPrimaryBytes;
            this.totalPrimarySize = instance.totalPrimarySize;
            this.version = instance.version;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public final Builder primaryShardCount(int value) {
            this.primaryShardCount = value;
            return this;
        }

        public final Builder totalPrimaryBytes(long value) {
            this.totalPrimaryBytes = value;
            return this;
        }

        public final Builder totalPrimarySize(@Nullable String value) {
            this.totalPrimarySize = value;
            return this;
        }

        public final Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicesVersions build() {
            this._checkSingleUse();
            return new IndicesVersions(this);
        }
    }
}

