/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorOffHeapStats
implements JsonpSerializable {
    private final long totalSizeBytes;
    @Nullable
    private final String totalSize;
    private final long totalVebSizeBytes;
    @Nullable
    private final String totalVebSize;
    private final long totalVecSizeBytes;
    @Nullable
    private final String totalVecSize;
    private final long totalVeqSizeBytes;
    @Nullable
    private final String totalVeqSize;
    private final long totalVexSizeBytes;
    @Nullable
    private final String totalVexSize;
    private final long totalCenifSizeBytes;
    @Nullable
    private final String totalCenifSize;
    private final long totalClivfSizeBytes;
    @Nullable
    private final String totalClivfSize;
    private final Map<String, Map<String, Long>> fielddata;
    public static final JsonpDeserializer<DenseVectorOffHeapStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorOffHeapStats::setupDenseVectorOffHeapStatsDeserializer);

    private DenseVectorOffHeapStats(Builder builder) {
        this.totalSizeBytes = ApiTypeHelper.requireNonNull(builder.totalSizeBytes, (Object)this, "totalSizeBytes", 0L);
        this.totalSize = builder.totalSize;
        this.totalVebSizeBytes = ApiTypeHelper.requireNonNull(builder.totalVebSizeBytes, (Object)this, "totalVebSizeBytes", 0L);
        this.totalVebSize = builder.totalVebSize;
        this.totalVecSizeBytes = ApiTypeHelper.requireNonNull(builder.totalVecSizeBytes, (Object)this, "totalVecSizeBytes", 0L);
        this.totalVecSize = builder.totalVecSize;
        this.totalVeqSizeBytes = ApiTypeHelper.requireNonNull(builder.totalVeqSizeBytes, (Object)this, "totalVeqSizeBytes", 0L);
        this.totalVeqSize = builder.totalVeqSize;
        this.totalVexSizeBytes = ApiTypeHelper.requireNonNull(builder.totalVexSizeBytes, (Object)this, "totalVexSizeBytes", 0L);
        this.totalVexSize = builder.totalVexSize;
        this.totalCenifSizeBytes = ApiTypeHelper.requireNonNull(builder.totalCenifSizeBytes, (Object)this, "totalCenifSizeBytes", 0L);
        this.totalCenifSize = builder.totalCenifSize;
        this.totalClivfSizeBytes = ApiTypeHelper.requireNonNull(builder.totalClivfSizeBytes, (Object)this, "totalClivfSizeBytes", 0L);
        this.totalClivfSize = builder.totalClivfSize;
        this.fielddata = ApiTypeHelper.unmodifiable(builder.fielddata);
    }

    public static DenseVectorOffHeapStats of(Function<Builder, ObjectBuilder<DenseVectorOffHeapStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long totalSizeBytes() {
        return this.totalSizeBytes;
    }

    @Nullable
    public final String totalSize() {
        return this.totalSize;
    }

    public final long totalVebSizeBytes() {
        return this.totalVebSizeBytes;
    }

    @Nullable
    public final String totalVebSize() {
        return this.totalVebSize;
    }

    public final long totalVecSizeBytes() {
        return this.totalVecSizeBytes;
    }

    @Nullable
    public final String totalVecSize() {
        return this.totalVecSize;
    }

    public final long totalVeqSizeBytes() {
        return this.totalVeqSizeBytes;
    }

    @Nullable
    public final String totalVeqSize() {
        return this.totalVeqSize;
    }

    public final long totalVexSizeBytes() {
        return this.totalVexSizeBytes;
    }

    @Nullable
    public final String totalVexSize() {
        return this.totalVexSize;
    }

    public final long totalCenifSizeBytes() {
        return this.totalCenifSizeBytes;
    }

    @Nullable
    public final String totalCenifSize() {
        return this.totalCenifSize;
    }

    public final long totalClivfSizeBytes() {
        return this.totalClivfSizeBytes;
    }

    @Nullable
    public final String totalClivfSize() {
        return this.totalClivfSize;
    }

    public final Map<String, Map<String, Long>> fielddata() {
        return this.fielddata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total_size_bytes");
        generator.write(this.totalSizeBytes);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
        generator.writeKey("total_veb_size_bytes");
        generator.write(this.totalVebSizeBytes);
        if (this.totalVebSize != null) {
            generator.writeKey("total_veb_size");
            generator.write(this.totalVebSize);
        }
        generator.writeKey("total_vec_size_bytes");
        generator.write(this.totalVecSizeBytes);
        if (this.totalVecSize != null) {
            generator.writeKey("total_vec_size");
            generator.write(this.totalVecSize);
        }
        generator.writeKey("total_veq_size_bytes");
        generator.write(this.totalVeqSizeBytes);
        if (this.totalVeqSize != null) {
            generator.writeKey("total_veq_size");
            generator.write(this.totalVeqSize);
        }
        generator.writeKey("total_vex_size_bytes");
        generator.write(this.totalVexSizeBytes);
        if (this.totalVexSize != null) {
            generator.writeKey("total_vex_size");
            generator.write(this.totalVexSize);
        }
        generator.writeKey("total_cenif_size_bytes");
        generator.write(this.totalCenifSizeBytes);
        if (this.totalCenifSize != null) {
            generator.writeKey("total_cenif_size");
            generator.write(this.totalCenifSize);
        }
        generator.writeKey("total_clivf_size_bytes");
        generator.write(this.totalClivfSizeBytes);
        if (this.totalClivfSize != null) {
            generator.writeKey("total_clivf_size");
            generator.write(this.totalClivfSize);
        }
        if (ApiTypeHelper.isDefined(this.fielddata)) {
            generator.writeKey("fielddata");
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, Long>> item0 : this.fielddata.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartObject();
                if (item0.getValue() != null) {
                    for (Map.Entry<String, Long> item1 : item0.getValue().entrySet()) {
                        generator.writeKey(item1.getKey());
                        generator.write(item1.getValue().longValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDenseVectorOffHeapStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::totalSizeBytes, JsonpDeserializer.longDeserializer(), "total_size_bytes");
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size");
        op.add(Builder::totalVebSizeBytes, JsonpDeserializer.longDeserializer(), "total_veb_size_bytes");
        op.add(Builder::totalVebSize, JsonpDeserializer.stringDeserializer(), "total_veb_size");
        op.add(Builder::totalVecSizeBytes, JsonpDeserializer.longDeserializer(), "total_vec_size_bytes");
        op.add(Builder::totalVecSize, JsonpDeserializer.stringDeserializer(), "total_vec_size");
        op.add(Builder::totalVeqSizeBytes, JsonpDeserializer.longDeserializer(), "total_veq_size_bytes");
        op.add(Builder::totalVeqSize, JsonpDeserializer.stringDeserializer(), "total_veq_size");
        op.add(Builder::totalVexSizeBytes, JsonpDeserializer.longDeserializer(), "total_vex_size_bytes");
        op.add(Builder::totalVexSize, JsonpDeserializer.stringDeserializer(), "total_vex_size");
        op.add(Builder::totalCenifSizeBytes, JsonpDeserializer.longDeserializer(), "total_cenif_size_bytes");
        op.add(Builder::totalCenifSize, JsonpDeserializer.stringDeserializer(), "total_cenif_size");
        op.add(Builder::totalClivfSizeBytes, JsonpDeserializer.longDeserializer(), "total_clivf_size_bytes");
        op.add(Builder::totalClivfSize, JsonpDeserializer.stringDeserializer(), "total_clivf_size");
        op.add(Builder::fielddata, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer())), "fielddata");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DenseVectorOffHeapStats> {
        private Long totalSizeBytes;
        @Nullable
        private String totalSize;
        private Long totalVebSizeBytes;
        @Nullable
        private String totalVebSize;
        private Long totalVecSizeBytes;
        @Nullable
        private String totalVecSize;
        private Long totalVeqSizeBytes;
        @Nullable
        private String totalVeqSize;
        private Long totalVexSizeBytes;
        @Nullable
        private String totalVexSize;
        private Long totalCenifSizeBytes;
        @Nullable
        private String totalCenifSize;
        private Long totalClivfSizeBytes;
        @Nullable
        private String totalClivfSize;
        @Nullable
        private Map<String, Map<String, Long>> fielddata;

        public Builder() {
        }

        private Builder(DenseVectorOffHeapStats instance) {
            this.totalSizeBytes = instance.totalSizeBytes;
            this.totalSize = instance.totalSize;
            this.totalVebSizeBytes = instance.totalVebSizeBytes;
            this.totalVebSize = instance.totalVebSize;
            this.totalVecSizeBytes = instance.totalVecSizeBytes;
            this.totalVecSize = instance.totalVecSize;
            this.totalVeqSizeBytes = instance.totalVeqSizeBytes;
            this.totalVeqSize = instance.totalVeqSize;
            this.totalVexSizeBytes = instance.totalVexSizeBytes;
            this.totalVexSize = instance.totalVexSize;
            this.totalCenifSizeBytes = instance.totalCenifSizeBytes;
            this.totalCenifSize = instance.totalCenifSize;
            this.totalClivfSizeBytes = instance.totalClivfSizeBytes;
            this.totalClivfSize = instance.totalClivfSize;
            this.fielddata = instance.fielddata;
        }

        public final Builder totalSizeBytes(long value) {
            this.totalSizeBytes = value;
            return this;
        }

        public final Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        public final Builder totalVebSizeBytes(long value) {
            this.totalVebSizeBytes = value;
            return this;
        }

        public final Builder totalVebSize(@Nullable String value) {
            this.totalVebSize = value;
            return this;
        }

        public final Builder totalVecSizeBytes(long value) {
            this.totalVecSizeBytes = value;
            return this;
        }

        public final Builder totalVecSize(@Nullable String value) {
            this.totalVecSize = value;
            return this;
        }

        public final Builder totalVeqSizeBytes(long value) {
            this.totalVeqSizeBytes = value;
            return this;
        }

        public final Builder totalVeqSize(@Nullable String value) {
            this.totalVeqSize = value;
            return this;
        }

        public final Builder totalVexSizeBytes(long value) {
            this.totalVexSizeBytes = value;
            return this;
        }

        public final Builder totalVexSize(@Nullable String value) {
            this.totalVexSize = value;
            return this;
        }

        public final Builder totalCenifSizeBytes(long value) {
            this.totalCenifSizeBytes = value;
            return this;
        }

        public final Builder totalCenifSize(@Nullable String value) {
            this.totalCenifSize = value;
            return this;
        }

        public final Builder totalClivfSizeBytes(long value) {
            this.totalClivfSizeBytes = value;
            return this;
        }

        public final Builder totalClivfSize(@Nullable String value) {
            this.totalClivfSize = value;
            return this;
        }

        public final Builder fielddata(Map<String, Map<String, Long>> map) {
            this.fielddata = Builder._mapPutAll(this.fielddata, map);
            return this;
        }

        public final Builder fielddata(String key, Map<String, Long> value) {
            this.fielddata = Builder._mapPut(this.fielddata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorOffHeapStats build() {
            this._checkSingleUse();
            return new DenseVectorOffHeapStats(this);
        }
    }
}

