/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformationReason;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UnassignedInformation
implements JsonpSerializable {
    private final DateTime at;
    @Nullable
    private final String lastAllocationStatus;
    private final UnassignedInformationReason reason;
    @Nullable
    private final String details;
    @Nullable
    private final Integer failedAllocationAttempts;
    @Nullable
    private final Boolean delayed;
    @Nullable
    private final String allocationStatus;
    public static final JsonpDeserializer<UnassignedInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UnassignedInformation::setupUnassignedInformationDeserializer);

    private UnassignedInformation(Builder builder) {
        this.at = ApiTypeHelper.requireNonNull(builder.at, this, "at");
        this.lastAllocationStatus = builder.lastAllocationStatus;
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.details = builder.details;
        this.failedAllocationAttempts = builder.failedAllocationAttempts;
        this.delayed = builder.delayed;
        this.allocationStatus = builder.allocationStatus;
    }

    public static UnassignedInformation of(Function<Builder, ObjectBuilder<UnassignedInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DateTime at() {
        return this.at;
    }

    @Nullable
    public final String lastAllocationStatus() {
        return this.lastAllocationStatus;
    }

    public final UnassignedInformationReason reason() {
        return this.reason;
    }

    @Nullable
    public final String details() {
        return this.details;
    }

    @Nullable
    public final Integer failedAllocationAttempts() {
        return this.failedAllocationAttempts;
    }

    @Nullable
    public final Boolean delayed() {
        return this.delayed;
    }

    @Nullable
    public final String allocationStatus() {
        return this.allocationStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("at");
        this.at.serialize(generator, mapper);
        if (this.lastAllocationStatus != null) {
            generator.writeKey("last_allocation_status");
            generator.write(this.lastAllocationStatus);
        }
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        if (this.details != null) {
            generator.writeKey("details");
            generator.write(this.details);
        }
        if (this.failedAllocationAttempts != null) {
            generator.writeKey("failed_allocation_attempts");
            generator.write(this.failedAllocationAttempts.intValue());
        }
        if (this.delayed != null) {
            generator.writeKey("delayed");
            generator.write(this.delayed.booleanValue());
        }
        if (this.allocationStatus != null) {
            generator.writeKey("allocation_status");
            generator.write(this.allocationStatus);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUnassignedInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::at, DateTime._DESERIALIZER, "at");
        op.add(Builder::lastAllocationStatus, JsonpDeserializer.stringDeserializer(), "last_allocation_status");
        op.add(Builder::reason, UnassignedInformationReason._DESERIALIZER, "reason");
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details");
        op.add(Builder::failedAllocationAttempts, JsonpDeserializer.integerDeserializer(), "failed_allocation_attempts");
        op.add(Builder::delayed, JsonpDeserializer.booleanDeserializer(), "delayed");
        op.add(Builder::allocationStatus, JsonpDeserializer.stringDeserializer(), "allocation_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UnassignedInformation> {
        private DateTime at;
        @Nullable
        private String lastAllocationStatus;
        private UnassignedInformationReason reason;
        @Nullable
        private String details;
        @Nullable
        private Integer failedAllocationAttempts;
        @Nullable
        private Boolean delayed;
        @Nullable
        private String allocationStatus;

        public Builder() {
        }

        private Builder(UnassignedInformation instance) {
            this.at = instance.at;
            this.lastAllocationStatus = instance.lastAllocationStatus;
            this.reason = instance.reason;
            this.details = instance.details;
            this.failedAllocationAttempts = instance.failedAllocationAttempts;
            this.delayed = instance.delayed;
            this.allocationStatus = instance.allocationStatus;
        }

        public final Builder at(DateTime value) {
            this.at = value;
            return this;
        }

        public final Builder lastAllocationStatus(@Nullable String value) {
            this.lastAllocationStatus = value;
            return this;
        }

        public final Builder reason(UnassignedInformationReason value) {
            this.reason = value;
            return this;
        }

        public final Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        public final Builder failedAllocationAttempts(@Nullable Integer value) {
            this.failedAllocationAttempts = value;
            return this;
        }

        public final Builder delayed(@Nullable Boolean value) {
            this.delayed = value;
            return this;
        }

        public final Builder allocationStatus(@Nullable String value) {
            this.allocationStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UnassignedInformation build() {
            this._checkSingleUse();
            return new UnassignedInformation(this);
        }
    }
}

