/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.StateResponse;
import co.elastic.clients.elasticsearch.cluster.state.ClusterStateMetric;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StateRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    private final List<ClusterStateMetric> metric;
    @Nullable
    private final Long waitForMetadataVersion;
    @Nullable
    private final Time waitForTimeout;
    public static final Endpoint<StateRequest, StateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StateRequest, StateResponse>("es/cluster.state", request -> "GET", request -> {
        boolean _metric = true;
        int _index = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cluster");
            buf.append("/state");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _metric = true;
        int _index = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            // empty if block
        }
        if (propsSet == 1) {
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (propsSet == 3) {
            params.put("metric", request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.waitForTimeout != null) {
            params.put("wait_for_timeout", request.waitForTimeout._toJsonString());
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.waitForMetadataVersion != null) {
            params.put("wait_for_metadata_version", String.valueOf(request.waitForMetadataVersion));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StateResponse._DESERIALIZER);

    private StateRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.flatSettings = builder.flatSettings;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.waitForMetadataVersion = builder.waitForMetadataVersion;
        this.waitForTimeout = builder.waitForTimeout;
    }

    public static StateRequest of(Function<Builder, ObjectBuilder<StateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Deprecated
    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<ClusterStateMetric> metric() {
        return this.metric;
    }

    @Nullable
    public final Long waitForMetadataVersion() {
        return this.waitForMetadataVersion;
    }

    @Nullable
    public final Time waitForTimeout() {
        return this.waitForTimeout;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StateRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<ClusterStateMetric> metric;
        @Nullable
        private Long waitForMetadataVersion;
        @Nullable
        private Time waitForTimeout;

        public Builder() {
        }

        private Builder(StateRequest instance) {
            this.allowNoIndices = instance.allowNoIndices;
            this.expandWildcards = instance.expandWildcards;
            this.flatSettings = instance.flatSettings;
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.index = instance.index;
            this.local = instance.local;
            this.masterTimeout = instance.masterTimeout;
            this.metric = instance.metric;
            this.waitForMetadataVersion = instance.waitForMetadataVersion;
            this.waitForTimeout = instance.waitForTimeout;
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Deprecated
        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder metric(List<ClusterStateMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(ClusterStateMetric value, ClusterStateMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        public final Builder waitForMetadataVersion(@Nullable Long value) {
            this.waitForMetadataVersion = value;
            return this;
        }

        public final Builder waitForTimeout(@Nullable Time value) {
            this.waitForTimeout = value;
            return this;
        }

        public final Builder waitForTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StateRequest build() {
            this._checkSingleUse();
            return new StateRequest(this);
        }
    }
}

