/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.transforms;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformsRecord
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String state;
    @Nullable
    private final String checkpoint;
    @Nullable
    private final String documentsProcessed;
    @Nullable
    private final String checkpointProgress;
    @Nullable
    private final String lastSearchTime;
    @Nullable
    private final String changesLastDetectionTime;
    @Nullable
    private final String createTime;
    @Nullable
    private final String version;
    @Nullable
    private final String sourceIndex;
    @Nullable
    private final String destIndex;
    @Nullable
    private final String pipeline;
    @Nullable
    private final String description;
    @Nullable
    private final String transformType;
    @Nullable
    private final String frequency;
    @Nullable
    private final String maxPageSearchSize;
    @Nullable
    private final String docsPerSecond;
    @Nullable
    private final String reason;
    @Nullable
    private final String searchTotal;
    @Nullable
    private final String searchFailure;
    @Nullable
    private final String searchTime;
    @Nullable
    private final String indexTotal;
    @Nullable
    private final String indexFailure;
    @Nullable
    private final String indexTime;
    @Nullable
    private final String documentsIndexed;
    @Nullable
    private final String deleteTime;
    @Nullable
    private final String documentsDeleted;
    @Nullable
    private final String triggerCount;
    @Nullable
    private final String pagesProcessed;
    @Nullable
    private final String processingTime;
    @Nullable
    private final String checkpointDurationTimeExpAvg;
    @Nullable
    private final String indexedDocumentsExpAvg;
    @Nullable
    private final String processedDocumentsExpAvg;
    public static final JsonpDeserializer<TransformsRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformsRecord::setupTransformsRecordDeserializer);

    private TransformsRecord(Builder builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.checkpoint = builder.checkpoint;
        this.documentsProcessed = builder.documentsProcessed;
        this.checkpointProgress = builder.checkpointProgress;
        this.lastSearchTime = builder.lastSearchTime;
        this.changesLastDetectionTime = builder.changesLastDetectionTime;
        this.createTime = builder.createTime;
        this.version = builder.version;
        this.sourceIndex = builder.sourceIndex;
        this.destIndex = builder.destIndex;
        this.pipeline = builder.pipeline;
        this.description = builder.description;
        this.transformType = builder.transformType;
        this.frequency = builder.frequency;
        this.maxPageSearchSize = builder.maxPageSearchSize;
        this.docsPerSecond = builder.docsPerSecond;
        this.reason = builder.reason;
        this.searchTotal = builder.searchTotal;
        this.searchFailure = builder.searchFailure;
        this.searchTime = builder.searchTime;
        this.indexTotal = builder.indexTotal;
        this.indexFailure = builder.indexFailure;
        this.indexTime = builder.indexTime;
        this.documentsIndexed = builder.documentsIndexed;
        this.deleteTime = builder.deleteTime;
        this.documentsDeleted = builder.documentsDeleted;
        this.triggerCount = builder.triggerCount;
        this.pagesProcessed = builder.pagesProcessed;
        this.processingTime = builder.processingTime;
        this.checkpointDurationTimeExpAvg = builder.checkpointDurationTimeExpAvg;
        this.indexedDocumentsExpAvg = builder.indexedDocumentsExpAvg;
        this.processedDocumentsExpAvg = builder.processedDocumentsExpAvg;
    }

    public static TransformsRecord of(Function<Builder, ObjectBuilder<TransformsRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String state() {
        return this.state;
    }

    @Nullable
    public final String checkpoint() {
        return this.checkpoint;
    }

    @Nullable
    public final String documentsProcessed() {
        return this.documentsProcessed;
    }

    @Nullable
    public final String checkpointProgress() {
        return this.checkpointProgress;
    }

    @Nullable
    public final String lastSearchTime() {
        return this.lastSearchTime;
    }

    @Nullable
    public final String changesLastDetectionTime() {
        return this.changesLastDetectionTime;
    }

    @Nullable
    public final String createTime() {
        return this.createTime;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final String sourceIndex() {
        return this.sourceIndex;
    }

    @Nullable
    public final String destIndex() {
        return this.destIndex;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String transformType() {
        return this.transformType;
    }

    @Nullable
    public final String frequency() {
        return this.frequency;
    }

    @Nullable
    public final String maxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    @Nullable
    public final String docsPerSecond() {
        return this.docsPerSecond;
    }

    @Nullable
    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final String searchTotal() {
        return this.searchTotal;
    }

    @Nullable
    public final String searchFailure() {
        return this.searchFailure;
    }

    @Nullable
    public final String searchTime() {
        return this.searchTime;
    }

    @Nullable
    public final String indexTotal() {
        return this.indexTotal;
    }

    @Nullable
    public final String indexFailure() {
        return this.indexFailure;
    }

    @Nullable
    public final String indexTime() {
        return this.indexTime;
    }

    @Nullable
    public final String documentsIndexed() {
        return this.documentsIndexed;
    }

    @Nullable
    public final String deleteTime() {
        return this.deleteTime;
    }

    @Nullable
    public final String documentsDeleted() {
        return this.documentsDeleted;
    }

    @Nullable
    public final String triggerCount() {
        return this.triggerCount;
    }

    @Nullable
    public final String pagesProcessed() {
        return this.pagesProcessed;
    }

    @Nullable
    public final String processingTime() {
        return this.processingTime;
    }

    @Nullable
    public final String checkpointDurationTimeExpAvg() {
        return this.checkpointDurationTimeExpAvg;
    }

    @Nullable
    public final String indexedDocumentsExpAvg() {
        return this.indexedDocumentsExpAvg;
    }

    @Nullable
    public final String processedDocumentsExpAvg() {
        return this.processedDocumentsExpAvg;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.state != null) {
            generator.writeKey("state");
            generator.write(this.state);
        }
        if (this.checkpoint != null) {
            generator.writeKey("checkpoint");
            generator.write(this.checkpoint);
        }
        if (this.documentsProcessed != null) {
            generator.writeKey("documents_processed");
            generator.write(this.documentsProcessed);
        }
        if (this.checkpointProgress != null) {
            generator.writeKey("checkpoint_progress");
            generator.write(this.checkpointProgress);
        }
        if (this.lastSearchTime != null) {
            generator.writeKey("last_search_time");
            generator.write(this.lastSearchTime);
        }
        if (this.changesLastDetectionTime != null) {
            generator.writeKey("changes_last_detection_time");
            generator.write(this.changesLastDetectionTime);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.sourceIndex != null) {
            generator.writeKey("source_index");
            generator.write(this.sourceIndex);
        }
        if (this.destIndex != null) {
            generator.writeKey("dest_index");
            generator.write(this.destIndex);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.transformType != null) {
            generator.writeKey("transform_type");
            generator.write(this.transformType);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            generator.write(this.frequency);
        }
        if (this.maxPageSearchSize != null) {
            generator.writeKey("max_page_search_size");
            generator.write(this.maxPageSearchSize);
        }
        if (this.docsPerSecond != null) {
            generator.writeKey("docs_per_second");
            generator.write(this.docsPerSecond);
        }
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
        if (this.searchTotal != null) {
            generator.writeKey("search_total");
            generator.write(this.searchTotal);
        }
        if (this.searchFailure != null) {
            generator.writeKey("search_failure");
            generator.write(this.searchFailure);
        }
        if (this.searchTime != null) {
            generator.writeKey("search_time");
            generator.write(this.searchTime);
        }
        if (this.indexTotal != null) {
            generator.writeKey("index_total");
            generator.write(this.indexTotal);
        }
        if (this.indexFailure != null) {
            generator.writeKey("index_failure");
            generator.write(this.indexFailure);
        }
        if (this.indexTime != null) {
            generator.writeKey("index_time");
            generator.write(this.indexTime);
        }
        if (this.documentsIndexed != null) {
            generator.writeKey("documents_indexed");
            generator.write(this.documentsIndexed);
        }
        if (this.deleteTime != null) {
            generator.writeKey("delete_time");
            generator.write(this.deleteTime);
        }
        if (this.documentsDeleted != null) {
            generator.writeKey("documents_deleted");
            generator.write(this.documentsDeleted);
        }
        if (this.triggerCount != null) {
            generator.writeKey("trigger_count");
            generator.write(this.triggerCount);
        }
        if (this.pagesProcessed != null) {
            generator.writeKey("pages_processed");
            generator.write(this.pagesProcessed);
        }
        if (this.processingTime != null) {
            generator.writeKey("processing_time");
            generator.write(this.processingTime);
        }
        if (this.checkpointDurationTimeExpAvg != null) {
            generator.writeKey("checkpoint_duration_time_exp_avg");
            generator.write(this.checkpointDurationTimeExpAvg);
        }
        if (this.indexedDocumentsExpAvg != null) {
            generator.writeKey("indexed_documents_exp_avg");
            generator.write(this.indexedDocumentsExpAvg);
        }
        if (this.processedDocumentsExpAvg != null) {
            generator.writeKey("processed_documents_exp_avg");
            generator.write(this.processedDocumentsExpAvg);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTransformsRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::state, JsonpDeserializer.stringDeserializer(), "state", "s");
        op.add(Builder::checkpoint, JsonpDeserializer.stringDeserializer(), "checkpoint", "c");
        op.add(Builder::documentsProcessed, JsonpDeserializer.stringDeserializer(), "documents_processed", "docp", "documentsProcessed");
        op.add(Builder::checkpointProgress, JsonpDeserializer.stringDeserializer(), "checkpoint_progress", "cp", "checkpointProgress");
        op.add(Builder::lastSearchTime, JsonpDeserializer.stringDeserializer(), "last_search_time", "lst", "lastSearchTime");
        op.add(Builder::changesLastDetectionTime, JsonpDeserializer.stringDeserializer(), "changes_last_detection_time", "cldt");
        op.add(Builder::createTime, JsonpDeserializer.stringDeserializer(), "create_time", "ct", "createTime");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", "v");
        op.add(Builder::sourceIndex, JsonpDeserializer.stringDeserializer(), "source_index", "si", "sourceIndex");
        op.add(Builder::destIndex, JsonpDeserializer.stringDeserializer(), "dest_index", "di", "destIndex");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline", "p");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", "d");
        op.add(Builder::transformType, JsonpDeserializer.stringDeserializer(), "transform_type", "tt");
        op.add(Builder::frequency, JsonpDeserializer.stringDeserializer(), "frequency", "f");
        op.add(Builder::maxPageSearchSize, JsonpDeserializer.stringDeserializer(), "max_page_search_size", "mpsz");
        op.add(Builder::docsPerSecond, JsonpDeserializer.stringDeserializer(), "docs_per_second", "dps");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", "r");
        op.add(Builder::searchTotal, JsonpDeserializer.stringDeserializer(), "search_total", "st");
        op.add(Builder::searchFailure, JsonpDeserializer.stringDeserializer(), "search_failure", "sf");
        op.add(Builder::searchTime, JsonpDeserializer.stringDeserializer(), "search_time", "stime");
        op.add(Builder::indexTotal, JsonpDeserializer.stringDeserializer(), "index_total", "it");
        op.add(Builder::indexFailure, JsonpDeserializer.stringDeserializer(), "index_failure", "if");
        op.add(Builder::indexTime, JsonpDeserializer.stringDeserializer(), "index_time", "itime");
        op.add(Builder::documentsIndexed, JsonpDeserializer.stringDeserializer(), "documents_indexed", "doci");
        op.add(Builder::deleteTime, JsonpDeserializer.stringDeserializer(), "delete_time", "dtime");
        op.add(Builder::documentsDeleted, JsonpDeserializer.stringDeserializer(), "documents_deleted", "docd");
        op.add(Builder::triggerCount, JsonpDeserializer.stringDeserializer(), "trigger_count", "tc");
        op.add(Builder::pagesProcessed, JsonpDeserializer.stringDeserializer(), "pages_processed", "pp");
        op.add(Builder::processingTime, JsonpDeserializer.stringDeserializer(), "processing_time", "pt");
        op.add(Builder::checkpointDurationTimeExpAvg, JsonpDeserializer.stringDeserializer(), "checkpoint_duration_time_exp_avg", "cdtea", "checkpointTimeExpAvg");
        op.add(Builder::indexedDocumentsExpAvg, JsonpDeserializer.stringDeserializer(), "indexed_documents_exp_avg", "idea");
        op.add(Builder::processedDocumentsExpAvg, JsonpDeserializer.stringDeserializer(), "processed_documents_exp_avg", "pdea");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformsRecord> {
        @Nullable
        private String id;
        @Nullable
        private String state;
        @Nullable
        private String checkpoint;
        @Nullable
        private String documentsProcessed;
        @Nullable
        private String checkpointProgress;
        @Nullable
        private String lastSearchTime;
        @Nullable
        private String changesLastDetectionTime;
        @Nullable
        private String createTime;
        @Nullable
        private String version;
        @Nullable
        private String sourceIndex;
        @Nullable
        private String destIndex;
        @Nullable
        private String pipeline;
        @Nullable
        private String description;
        @Nullable
        private String transformType;
        @Nullable
        private String frequency;
        @Nullable
        private String maxPageSearchSize;
        @Nullable
        private String docsPerSecond;
        @Nullable
        private String reason;
        @Nullable
        private String searchTotal;
        @Nullable
        private String searchFailure;
        @Nullable
        private String searchTime;
        @Nullable
        private String indexTotal;
        @Nullable
        private String indexFailure;
        @Nullable
        private String indexTime;
        @Nullable
        private String documentsIndexed;
        @Nullable
        private String deleteTime;
        @Nullable
        private String documentsDeleted;
        @Nullable
        private String triggerCount;
        @Nullable
        private String pagesProcessed;
        @Nullable
        private String processingTime;
        @Nullable
        private String checkpointDurationTimeExpAvg;
        @Nullable
        private String indexedDocumentsExpAvg;
        @Nullable
        private String processedDocumentsExpAvg;

        public Builder() {
        }

        private Builder(TransformsRecord instance) {
            this.id = instance.id;
            this.state = instance.state;
            this.checkpoint = instance.checkpoint;
            this.documentsProcessed = instance.documentsProcessed;
            this.checkpointProgress = instance.checkpointProgress;
            this.lastSearchTime = instance.lastSearchTime;
            this.changesLastDetectionTime = instance.changesLastDetectionTime;
            this.createTime = instance.createTime;
            this.version = instance.version;
            this.sourceIndex = instance.sourceIndex;
            this.destIndex = instance.destIndex;
            this.pipeline = instance.pipeline;
            this.description = instance.description;
            this.transformType = instance.transformType;
            this.frequency = instance.frequency;
            this.maxPageSearchSize = instance.maxPageSearchSize;
            this.docsPerSecond = instance.docsPerSecond;
            this.reason = instance.reason;
            this.searchTotal = instance.searchTotal;
            this.searchFailure = instance.searchFailure;
            this.searchTime = instance.searchTime;
            this.indexTotal = instance.indexTotal;
            this.indexFailure = instance.indexFailure;
            this.indexTime = instance.indexTime;
            this.documentsIndexed = instance.documentsIndexed;
            this.deleteTime = instance.deleteTime;
            this.documentsDeleted = instance.documentsDeleted;
            this.triggerCount = instance.triggerCount;
            this.pagesProcessed = instance.pagesProcessed;
            this.processingTime = instance.processingTime;
            this.checkpointDurationTimeExpAvg = instance.checkpointDurationTimeExpAvg;
            this.indexedDocumentsExpAvg = instance.indexedDocumentsExpAvg;
            this.processedDocumentsExpAvg = instance.processedDocumentsExpAvg;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder state(@Nullable String value) {
            this.state = value;
            return this;
        }

        public final Builder checkpoint(@Nullable String value) {
            this.checkpoint = value;
            return this;
        }

        public final Builder documentsProcessed(@Nullable String value) {
            this.documentsProcessed = value;
            return this;
        }

        public final Builder checkpointProgress(@Nullable String value) {
            this.checkpointProgress = value;
            return this;
        }

        public final Builder lastSearchTime(@Nullable String value) {
            this.lastSearchTime = value;
            return this;
        }

        public final Builder changesLastDetectionTime(@Nullable String value) {
            this.changesLastDetectionTime = value;
            return this;
        }

        public final Builder createTime(@Nullable String value) {
            this.createTime = value;
            return this;
        }

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder sourceIndex(@Nullable String value) {
            this.sourceIndex = value;
            return this;
        }

        public final Builder destIndex(@Nullable String value) {
            this.destIndex = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder transformType(@Nullable String value) {
            this.transformType = value;
            return this;
        }

        public final Builder frequency(@Nullable String value) {
            this.frequency = value;
            return this;
        }

        public final Builder maxPageSearchSize(@Nullable String value) {
            this.maxPageSearchSize = value;
            return this;
        }

        public final Builder docsPerSecond(@Nullable String value) {
            this.docsPerSecond = value;
            return this;
        }

        public final Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        public final Builder searchTotal(@Nullable String value) {
            this.searchTotal = value;
            return this;
        }

        public final Builder searchFailure(@Nullable String value) {
            this.searchFailure = value;
            return this;
        }

        public final Builder searchTime(@Nullable String value) {
            this.searchTime = value;
            return this;
        }

        public final Builder indexTotal(@Nullable String value) {
            this.indexTotal = value;
            return this;
        }

        public final Builder indexFailure(@Nullable String value) {
            this.indexFailure = value;
            return this;
        }

        public final Builder indexTime(@Nullable String value) {
            this.indexTime = value;
            return this;
        }

        public final Builder documentsIndexed(@Nullable String value) {
            this.documentsIndexed = value;
            return this;
        }

        public final Builder deleteTime(@Nullable String value) {
            this.deleteTime = value;
            return this;
        }

        public final Builder documentsDeleted(@Nullable String value) {
            this.documentsDeleted = value;
            return this;
        }

        public final Builder triggerCount(@Nullable String value) {
            this.triggerCount = value;
            return this;
        }

        public final Builder pagesProcessed(@Nullable String value) {
            this.pagesProcessed = value;
            return this;
        }

        public final Builder processingTime(@Nullable String value) {
            this.processingTime = value;
            return this;
        }

        public final Builder checkpointDurationTimeExpAvg(@Nullable String value) {
            this.checkpointDurationTimeExpAvg = value;
            return this;
        }

        public final Builder indexedDocumentsExpAvg(@Nullable String value) {
            this.indexedDocumentsExpAvg = value;
            return this;
        }

        public final Builder processedDocumentsExpAvg(@Nullable String value) {
            this.processedDocumentsExpAvg = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformsRecord build() {
            this._checkSingleUse();
            return new TransformsRecord(this);
        }
    }
}

