/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.recovery;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RecoveryRecord
implements JsonpSerializable {
    @Nullable
    private final String index;
    @Nullable
    private final String shard;
    @Nullable
    private final DateTime startTime;
    @Nullable
    private final Long startTimeMillis;
    @Nullable
    private final DateTime stopTime;
    @Nullable
    private final Long stopTimeMillis;
    @Nullable
    private final Time time;
    @Nullable
    private final String type;
    @Nullable
    private final String stage;
    @Nullable
    private final String sourceHost;
    @Nullable
    private final String sourceNode;
    @Nullable
    private final String targetHost;
    @Nullable
    private final String targetNode;
    @Nullable
    private final String repository;
    @Nullable
    private final String snapshot;
    @Nullable
    private final String files;
    @Nullable
    private final String filesRecovered;
    @Nullable
    private final String filesPercent;
    @Nullable
    private final String filesTotal;
    @Nullable
    private final String bytes;
    @Nullable
    private final String bytesRecovered;
    @Nullable
    private final String bytesPercent;
    @Nullable
    private final String bytesTotal;
    @Nullable
    private final String translogOps;
    @Nullable
    private final String translogOpsRecovered;
    @Nullable
    private final String translogOpsPercent;
    public static final JsonpDeserializer<RecoveryRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryRecord::setupRecoveryRecordDeserializer);

    private RecoveryRecord(Builder builder) {
        this.index = builder.index;
        this.shard = builder.shard;
        this.startTime = builder.startTime;
        this.startTimeMillis = builder.startTimeMillis;
        this.stopTime = builder.stopTime;
        this.stopTimeMillis = builder.stopTimeMillis;
        this.time = builder.time;
        this.type = builder.type;
        this.stage = builder.stage;
        this.sourceHost = builder.sourceHost;
        this.sourceNode = builder.sourceNode;
        this.targetHost = builder.targetHost;
        this.targetNode = builder.targetNode;
        this.repository = builder.repository;
        this.snapshot = builder.snapshot;
        this.files = builder.files;
        this.filesRecovered = builder.filesRecovered;
        this.filesPercent = builder.filesPercent;
        this.filesTotal = builder.filesTotal;
        this.bytes = builder.bytes;
        this.bytesRecovered = builder.bytesRecovered;
        this.bytesPercent = builder.bytesPercent;
        this.bytesTotal = builder.bytesTotal;
        this.translogOps = builder.translogOps;
        this.translogOpsRecovered = builder.translogOpsRecovered;
        this.translogOpsPercent = builder.translogOpsPercent;
    }

    public static RecoveryRecord of(Function<Builder, ObjectBuilder<RecoveryRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String shard() {
        return this.shard;
    }

    @Nullable
    public final DateTime startTime() {
        return this.startTime;
    }

    @Nullable
    public final Long startTimeMillis() {
        return this.startTimeMillis;
    }

    @Nullable
    public final DateTime stopTime() {
        return this.stopTime;
    }

    @Nullable
    public final Long stopTimeMillis() {
        return this.stopTimeMillis;
    }

    @Nullable
    public final Time time() {
        return this.time;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final String stage() {
        return this.stage;
    }

    @Nullable
    public final String sourceHost() {
        return this.sourceHost;
    }

    @Nullable
    public final String sourceNode() {
        return this.sourceNode;
    }

    @Nullable
    public final String targetHost() {
        return this.targetHost;
    }

    @Nullable
    public final String targetNode() {
        return this.targetNode;
    }

    @Nullable
    public final String repository() {
        return this.repository;
    }

    @Nullable
    public final String snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final String files() {
        return this.files;
    }

    @Nullable
    public final String filesRecovered() {
        return this.filesRecovered;
    }

    @Nullable
    public final String filesPercent() {
        return this.filesPercent;
    }

    @Nullable
    public final String filesTotal() {
        return this.filesTotal;
    }

    @Nullable
    public final String bytes() {
        return this.bytes;
    }

    @Nullable
    public final String bytesRecovered() {
        return this.bytesRecovered;
    }

    @Nullable
    public final String bytesPercent() {
        return this.bytesPercent;
    }

    @Nullable
    public final String bytesTotal() {
        return this.bytesTotal;
    }

    @Nullable
    public final String translogOps() {
        return this.translogOps;
    }

    @Nullable
    public final String translogOpsRecovered() {
        return this.translogOpsRecovered;
    }

    @Nullable
    public final String translogOpsPercent() {
        return this.translogOpsPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
        if (this.startTimeMillis != null) {
            generator.writeKey("start_time_millis");
            generator.write(this.startTimeMillis.longValue());
        }
        if (this.stopTime != null) {
            generator.writeKey("stop_time");
            this.stopTime.serialize(generator, mapper);
        }
        if (this.stopTimeMillis != null) {
            generator.writeKey("stop_time_millis");
            generator.write(this.stopTimeMillis.longValue());
        }
        if (this.time != null) {
            generator.writeKey("time");
            this.time.serialize(generator, mapper);
        }
        if (this.type != null) {
            generator.writeKey("type");
            generator.write(this.type);
        }
        if (this.stage != null) {
            generator.writeKey("stage");
            generator.write(this.stage);
        }
        if (this.sourceHost != null) {
            generator.writeKey("source_host");
            generator.write(this.sourceHost);
        }
        if (this.sourceNode != null) {
            generator.writeKey("source_node");
            generator.write(this.sourceNode);
        }
        if (this.targetHost != null) {
            generator.writeKey("target_host");
            generator.write(this.targetHost);
        }
        if (this.targetNode != null) {
            generator.writeKey("target_node");
            generator.write(this.targetNode);
        }
        if (this.repository != null) {
            generator.writeKey("repository");
            generator.write(this.repository);
        }
        if (this.snapshot != null) {
            generator.writeKey("snapshot");
            generator.write(this.snapshot);
        }
        if (this.files != null) {
            generator.writeKey("files");
            generator.write(this.files);
        }
        if (this.filesRecovered != null) {
            generator.writeKey("files_recovered");
            generator.write(this.filesRecovered);
        }
        if (this.filesPercent != null) {
            generator.writeKey("files_percent");
            generator.write(this.filesPercent);
        }
        if (this.filesTotal != null) {
            generator.writeKey("files_total");
            generator.write(this.filesTotal);
        }
        if (this.bytes != null) {
            generator.writeKey("bytes");
            generator.write(this.bytes);
        }
        if (this.bytesRecovered != null) {
            generator.writeKey("bytes_recovered");
            generator.write(this.bytesRecovered);
        }
        if (this.bytesPercent != null) {
            generator.writeKey("bytes_percent");
            generator.write(this.bytesPercent);
        }
        if (this.bytesTotal != null) {
            generator.writeKey("bytes_total");
            generator.write(this.bytesTotal);
        }
        if (this.translogOps != null) {
            generator.writeKey("translog_ops");
            generator.write(this.translogOps);
        }
        if (this.translogOpsRecovered != null) {
            generator.writeKey("translog_ops_recovered");
            generator.write(this.translogOpsRecovered);
        }
        if (this.translogOpsPercent != null) {
            generator.writeKey("translog_ops_percent");
            generator.write(this.translogOpsPercent);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRecoveryRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", "i", "idx");
        op.add(Builder::shard, JsonpDeserializer.stringDeserializer(), "shard", "s", "sh");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time", "start");
        op.add(Builder::startTimeMillis, JsonpDeserializer.longDeserializer(), "start_time_millis", "start_millis");
        op.add(Builder::stopTime, DateTime._DESERIALIZER, "stop_time", "stop");
        op.add(Builder::stopTimeMillis, JsonpDeserializer.longDeserializer(), "stop_time_millis", "stop_millis");
        op.add(Builder::time, Time._DESERIALIZER, "time", "t", "ti");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", "ty");
        op.add(Builder::stage, JsonpDeserializer.stringDeserializer(), "stage", "st");
        op.add(Builder::sourceHost, JsonpDeserializer.stringDeserializer(), "source_host", "shost");
        op.add(Builder::sourceNode, JsonpDeserializer.stringDeserializer(), "source_node", "snode");
        op.add(Builder::targetHost, JsonpDeserializer.stringDeserializer(), "target_host", "thost");
        op.add(Builder::targetNode, JsonpDeserializer.stringDeserializer(), "target_node", "tnode");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository", "rep");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot", "snap");
        op.add(Builder::files, JsonpDeserializer.stringDeserializer(), "files", "f");
        op.add(Builder::filesRecovered, JsonpDeserializer.stringDeserializer(), "files_recovered", "fr");
        op.add(Builder::filesPercent, JsonpDeserializer.stringDeserializer(), "files_percent", "fp");
        op.add(Builder::filesTotal, JsonpDeserializer.stringDeserializer(), "files_total", "tf");
        op.add(Builder::bytes, JsonpDeserializer.stringDeserializer(), "bytes", "b");
        op.add(Builder::bytesRecovered, JsonpDeserializer.stringDeserializer(), "bytes_recovered", "br");
        op.add(Builder::bytesPercent, JsonpDeserializer.stringDeserializer(), "bytes_percent", "bp");
        op.add(Builder::bytesTotal, JsonpDeserializer.stringDeserializer(), "bytes_total", "tb");
        op.add(Builder::translogOps, JsonpDeserializer.stringDeserializer(), "translog_ops", "to");
        op.add(Builder::translogOpsRecovered, JsonpDeserializer.stringDeserializer(), "translog_ops_recovered", "tor");
        op.add(Builder::translogOpsPercent, JsonpDeserializer.stringDeserializer(), "translog_ops_percent", "top");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryRecord> {
        @Nullable
        private String index;
        @Nullable
        private String shard;
        @Nullable
        private DateTime startTime;
        @Nullable
        private Long startTimeMillis;
        @Nullable
        private DateTime stopTime;
        @Nullable
        private Long stopTimeMillis;
        @Nullable
        private Time time;
        @Nullable
        private String type;
        @Nullable
        private String stage;
        @Nullable
        private String sourceHost;
        @Nullable
        private String sourceNode;
        @Nullable
        private String targetHost;
        @Nullable
        private String targetNode;
        @Nullable
        private String repository;
        @Nullable
        private String snapshot;
        @Nullable
        private String files;
        @Nullable
        private String filesRecovered;
        @Nullable
        private String filesPercent;
        @Nullable
        private String filesTotal;
        @Nullable
        private String bytes;
        @Nullable
        private String bytesRecovered;
        @Nullable
        private String bytesPercent;
        @Nullable
        private String bytesTotal;
        @Nullable
        private String translogOps;
        @Nullable
        private String translogOpsRecovered;
        @Nullable
        private String translogOpsPercent;

        public Builder() {
        }

        private Builder(RecoveryRecord instance) {
            this.index = instance.index;
            this.shard = instance.shard;
            this.startTime = instance.startTime;
            this.startTimeMillis = instance.startTimeMillis;
            this.stopTime = instance.stopTime;
            this.stopTimeMillis = instance.stopTimeMillis;
            this.time = instance.time;
            this.type = instance.type;
            this.stage = instance.stage;
            this.sourceHost = instance.sourceHost;
            this.sourceNode = instance.sourceNode;
            this.targetHost = instance.targetHost;
            this.targetNode = instance.targetNode;
            this.repository = instance.repository;
            this.snapshot = instance.snapshot;
            this.files = instance.files;
            this.filesRecovered = instance.filesRecovered;
            this.filesPercent = instance.filesPercent;
            this.filesTotal = instance.filesTotal;
            this.bytes = instance.bytes;
            this.bytesRecovered = instance.bytesRecovered;
            this.bytesPercent = instance.bytesPercent;
            this.bytesTotal = instance.bytesTotal;
            this.translogOps = instance.translogOps;
            this.translogOpsRecovered = instance.translogOpsRecovered;
            this.translogOpsPercent = instance.translogOpsPercent;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder shard(@Nullable String value) {
            this.shard = value;
            return this;
        }

        public final Builder startTime(@Nullable DateTime value) {
            this.startTime = value;
            return this;
        }

        public final Builder startTimeMillis(@Nullable Long value) {
            this.startTimeMillis = value;
            return this;
        }

        public final Builder stopTime(@Nullable DateTime value) {
            this.stopTime = value;
            return this;
        }

        public final Builder stopTimeMillis(@Nullable Long value) {
            this.stopTimeMillis = value;
            return this;
        }

        public final Builder time(@Nullable Time value) {
            this.time = value;
            return this;
        }

        public final Builder time(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.time(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder stage(@Nullable String value) {
            this.stage = value;
            return this;
        }

        public final Builder sourceHost(@Nullable String value) {
            this.sourceHost = value;
            return this;
        }

        public final Builder sourceNode(@Nullable String value) {
            this.sourceNode = value;
            return this;
        }

        public final Builder targetHost(@Nullable String value) {
            this.targetHost = value;
            return this;
        }

        public final Builder targetNode(@Nullable String value) {
            this.targetNode = value;
            return this;
        }

        public final Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(@Nullable String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder files(@Nullable String value) {
            this.files = value;
            return this;
        }

        public final Builder filesRecovered(@Nullable String value) {
            this.filesRecovered = value;
            return this;
        }

        public final Builder filesPercent(@Nullable String value) {
            this.filesPercent = value;
            return this;
        }

        public final Builder filesTotal(@Nullable String value) {
            this.filesTotal = value;
            return this;
        }

        public final Builder bytes(@Nullable String value) {
            this.bytes = value;
            return this;
        }

        public final Builder bytesRecovered(@Nullable String value) {
            this.bytesRecovered = value;
            return this;
        }

        public final Builder bytesPercent(@Nullable String value) {
            this.bytesPercent = value;
            return this;
        }

        public final Builder bytesTotal(@Nullable String value) {
            this.bytesTotal = value;
            return this;
        }

        public final Builder translogOps(@Nullable String value) {
            this.translogOps = value;
            return this;
        }

        public final Builder translogOpsRecovered(@Nullable String value) {
            this.translogOpsRecovered = value;
            return this;
        }

        public final Builder translogOpsPercent(@Nullable String value) {
            this.translogOpsPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryRecord build() {
            this._checkSingleUse();
            return new RecoveryRecord(this);
        }
    }
}

