/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.nodeattrs;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeAttributesRecord
implements JsonpSerializable {
    @Nullable
    private final String node;
    @Nullable
    private final String id;
    @Nullable
    private final String pid;
    @Nullable
    private final String host;
    @Nullable
    private final String ip;
    @Nullable
    private final String port;
    @Nullable
    private final String attr;
    @Nullable
    private final String value;
    public static final JsonpDeserializer<NodeAttributesRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeAttributesRecord::setupNodeAttributesRecordDeserializer);

    private NodeAttributesRecord(Builder builder) {
        this.node = builder.node;
        this.id = builder.id;
        this.pid = builder.pid;
        this.host = builder.host;
        this.ip = builder.ip;
        this.port = builder.port;
        this.attr = builder.attr;
        this.value = builder.value;
    }

    public static NodeAttributesRecord of(Function<Builder, ObjectBuilder<NodeAttributesRecord>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String pid() {
        return this.pid;
    }

    @Nullable
    public final String host() {
        return this.host;
    }

    @Nullable
    public final String ip() {
        return this.ip;
    }

    @Nullable
    public final String port() {
        return this.port;
    }

    @Nullable
    public final String attr() {
        return this.attr;
    }

    @Nullable
    public final String value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.node != null) {
            generator.writeKey("node");
            generator.write(this.node);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.pid != null) {
            generator.writeKey("pid");
            generator.write(this.pid);
        }
        if (this.host != null) {
            generator.writeKey("host");
            generator.write(this.host);
        }
        if (this.ip != null) {
            generator.writeKey("ip");
            generator.write(this.ip);
        }
        if (this.port != null) {
            generator.writeKey("port");
            generator.write(this.port);
        }
        if (this.attr != null) {
            generator.writeKey("attr");
            generator.write(this.attr);
        }
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeAttributesRecordDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::pid, JsonpDeserializer.stringDeserializer(), "pid");
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", "h");
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip", "i");
        op.add(Builder::port, JsonpDeserializer.stringDeserializer(), "port");
        op.add(Builder::attr, JsonpDeserializer.stringDeserializer(), "attr");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeAttributesRecord> {
        @Nullable
        private String node;
        @Nullable
        private String id;
        @Nullable
        private String pid;
        @Nullable
        private String host;
        @Nullable
        private String ip;
        @Nullable
        private String port;
        @Nullable
        private String attr;
        @Nullable
        private String value;

        public Builder() {
        }

        private Builder(NodeAttributesRecord instance) {
            this.node = instance.node;
            this.id = instance.id;
            this.pid = instance.pid;
            this.host = instance.host;
            this.ip = instance.ip;
            this.port = instance.port;
            this.attr = instance.attr;
            this.value = instance.value;
        }

        public final Builder node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder pid(@Nullable String value) {
            this.pid = value;
            return this;
        }

        public final Builder host(@Nullable String value) {
            this.host = value;
            return this;
        }

        public final Builder ip(@Nullable String value) {
            this.ip = value;
            return this;
        }

        public final Builder port(@Nullable String value) {
            this.port = value;
            return this;
        }

        public final Builder attr(@Nullable String value) {
            this.attr = value;
            return this;
        }

        public final Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeAttributesRecord build() {
            this._checkSingleUse();
            return new NodeAttributesRecord(this);
        }
    }
}

