/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatCountColumn;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CountResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CountRequest
extends CatRequestBase
implements JsonpSerializable {
    @Nullable
    private final Bytes bytes;
    private final List<String> h;
    private final List<String> index;
    @Nullable
    private final String projectRouting;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    public static final JsonpDeserializer<CountRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CountRequest::setupCountRequestDeserializer);
    public static final Endpoint<CountRequest, CountResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CountRequest, CountResponse>("es/cat.count", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CountResponse._DESERIALIZER);

    private CountRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.projectRouting = builder.projectRouting;
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
    }

    public static CountRequest of(Function<Builder, ObjectBuilder<CountRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<String> h() {
        return this.h;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final String projectRouting() {
        return this.projectRouting;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.projectRouting != null) {
            generator.writeKey("project_routing");
            generator.write(this.projectRouting);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCountRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::projectRouting, JsonpDeserializer.stringDeserializer(), "project_routing");
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CountRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> h;
        @Nullable
        private List<String> index;
        @Nullable
        private String projectRouting;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;

        public Builder() {
        }

        private Builder(CountRequest instance) {
            this.bytes = instance.bytes;
            this.h = instance.h;
            this.index = instance.index;
            this.projectRouting = instance.projectRouting;
            this.s = instance.s;
            this.time = instance.time;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder h(CatCountColumn value, CatCountColumn ... values) {
            this.h = Builder._listAdd(this.h, value.jsonValue(), (String[])Arrays.stream(values).map(CatCountColumn::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder projectRouting(@Nullable String value) {
            this.projectRouting = value;
            return this;
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CountRequest build() {
            this._checkSingleUse();
            return new CountRequest(this);
        }
    }
}

