/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TermsSetQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final String minimumShouldMatchField;
    @Nullable
    private final Script minimumShouldMatchScript;
    private final List<FieldValue> terms;
    public static final JsonpDeserializer<TermsSetQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsSetQuery::setupTermsSetQueryDeserializer);

    private TermsSetQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.minimumShouldMatchField = builder.minimumShouldMatchField;
        this.minimumShouldMatchScript = builder.minimumShouldMatchScript;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static TermsSetQuery of(Function<Builder, ObjectBuilder<TermsSetQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.TermsSet;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final String minimumShouldMatchField() {
        return this.minimumShouldMatchField;
    }

    @Nullable
    public final Script minimumShouldMatchScript() {
        return this.minimumShouldMatchScript;
    }

    public final List<FieldValue> terms() {
        return this.terms;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.minimumShouldMatchField != null) {
            generator.writeKey("minimum_should_match_field");
            generator.write(this.minimumShouldMatchField);
        }
        if (this.minimumShouldMatchScript != null) {
            generator.writeKey("minimum_should_match_script");
            this.minimumShouldMatchScript.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartArray();
            for (FieldValue item0 : this.terms) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTermsSetQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::minimumShouldMatchField, JsonpDeserializer.stringDeserializer(), "minimum_should_match_field");
        op.add(Builder::minimumShouldMatchScript, Script._DESERIALIZER, "minimum_should_match_script");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "terms");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TermsSetQuery> {
        private String field;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private String minimumShouldMatchField;
        @Nullable
        private Script minimumShouldMatchScript;
        private List<FieldValue> terms;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder() {
        }

        private Builder(TermsSetQuery instance) {
            this.minimumShouldMatch = instance.minimumShouldMatch;
            this.minimumShouldMatchField = instance.minimumShouldMatchField;
            this.minimumShouldMatchScript = instance.minimumShouldMatchScript;
            this.terms = instance.terms;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder minimumShouldMatchField(@Nullable String value) {
            this.minimumShouldMatchField = value;
            return this;
        }

        public final Builder minimumShouldMatchScript(@Nullable Script value) {
            this.minimumShouldMatchScript = value;
            return this;
        }

        public final Builder minimumShouldMatchScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.minimumShouldMatchScript(fn.apply(new Script.Builder()).build());
        }

        public final Builder terms(List<FieldValue> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        public final Builder terms(FieldValue value, FieldValue ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        public final Builder terms(String value, String ... values) {
            this.terms = Builder._listAdd(this.terms, FieldValue.of(value), new FieldValue[0]);
            for (String v : values) {
                Builder._listAdd(this.terms, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder terms(long value, long ... values) {
            this.terms = Builder._listAdd(this.terms, FieldValue.of(value), new FieldValue[0]);
            for (long v : values) {
                Builder._listAdd(this.terms, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder terms(double value, double ... values) {
            this.terms = Builder._listAdd(this.terms, FieldValue.of(value), new FieldValue[0]);
            for (double v : values) {
                Builder._listAdd(this.terms, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder terms(boolean value, boolean ... values) {
            this.terms = Builder._listAdd(this.terms, FieldValue.of(value), new FieldValue[0]);
            for (boolean v : values) {
                Builder._listAdd(this.terms, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder terms(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.terms(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TermsSetQuery build() {
            this._checkSingleUse();
            return new TermsSetQuery(this);
        }
    }
}

