/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NumberRangeQuery
extends RangeQueryBase<Double>
implements RangeQueryVariant {
    private final String field;
    public static final JsonpDeserializer<NumberRangeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NumberRangeQuery::setupNumberRangeQueryDeserializer);

    private NumberRangeQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
    }

    public static NumberRangeQuery of(Function<Builder, ObjectBuilder<NumberRangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RangeQuery.Kind _rangeQueryKind() {
        return RangeQuery.Kind.Number;
    }

    public final String field() {
        return this.field;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNumberRangeQueryDeserializer(ObjectDeserializer<Builder> op) {
        RangeQueryBase.setupRangeQueryBaseDeserializer(op, JsonpDeserializer.doubleDeserializer());
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends RangeQueryBase.AbstractBuilder<Double, Builder>
    implements ObjectBuilder<NumberRangeQuery> {
        private String field;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder() {
        }

        private Builder(NumberRangeQuery instance) {
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NumberRangeQuery build() {
            this._checkSingleUse();
            super.tSerializer(null);
            return new NumberRangeQuery(this);
        }
    }
}

