/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsOperator;
import co.elastic.clients.elasticsearch._types.query_dsl.CombinedFieldsZeroTerms;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CombinedFieldsQuery
extends QueryBase
implements QueryVariant {
    private final List<String> fields;
    private final String query;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final CombinedFieldsOperator operator;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final CombinedFieldsZeroTerms zeroTermsQuery;
    public static final JsonpDeserializer<CombinedFieldsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CombinedFieldsQuery::setupCombinedFieldsQueryDeserializer);

    private CombinedFieldsQuery(Builder builder) {
        super(builder);
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.operator = builder.operator;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.zeroTermsQuery = builder.zeroTermsQuery;
    }

    public static CombinedFieldsQuery of(Function<Builder, ObjectBuilder<CombinedFieldsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.CombinedFields;
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public final CombinedFieldsOperator operator() {
        return this.operator;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final CombinedFieldsZeroTerms zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.operator != null) {
            generator.writeKey("operator");
            this.operator.serialize(generator, mapper);
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.zeroTermsQuery != null) {
            generator.writeKey("zero_terms_query");
            this.zeroTermsQuery.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCombinedFieldsQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::operator, CombinedFieldsOperator._DESERIALIZER, "operator");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::zeroTermsQuery, CombinedFieldsZeroTerms._DESERIALIZER, "zero_terms_query");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CombinedFieldsQuery> {
        private List<String> fields;
        private String query;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private CombinedFieldsOperator operator;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private CombinedFieldsZeroTerms zeroTermsQuery;

        public Builder() {
        }

        private Builder(CombinedFieldsQuery instance) {
            this.fields = instance.fields;
            this.query = instance.query;
            this.autoGenerateSynonymsPhraseQuery = instance.autoGenerateSynonymsPhraseQuery;
            this.operator = instance.operator;
            this.minimumShouldMatch = instance.minimumShouldMatch;
            this.zeroTermsQuery = instance.zeroTermsQuery;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public final Builder operator(@Nullable CombinedFieldsOperator value) {
            this.operator = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder zeroTermsQuery(@Nullable CombinedFieldsZeroTerms value) {
            this.zeroTermsQuery = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CombinedFieldsQuery build() {
            this._checkSingleUse();
            return new CombinedFieldsQuery(this);
        }
    }
}

