/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WildcardProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String nullValue;
    public static final JsonpDeserializer<WildcardProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WildcardProperty::setupWildcardPropertyDeserializer);

    private WildcardProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static WildcardProperty of(Function<Builder, ObjectBuilder<WildcardProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Wildcard;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "wildcard");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWildcardPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WildcardProperty> {
        @Nullable
        private String nullValue;

        public Builder() {
        }

        private Builder(WildcardProperty instance) {
            this.nullValue = instance.nullValue;
        }

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WildcardProperty build() {
            this._checkSingleUse();
            return new WildcardProperty(this);
        }
    }
}

